/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.crypto.ISymCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class SymCipherMultithreadedCTR
implements ISymCipher {
    private Cipher m_aesEngine1;
    private Cipher m_aesEngine2;
    private byte[] m_iv1 = null;
    private byte[] m_iv2 = null;
    private byte[] m_aesKeys;
    private static final int OPAD_LEN = 65536;
    private byte[] m_arCounters1;
    private byte[] m_arOpads1;
    private int m_nrThreads = 2;
    private int m_iOpadPerThread;
    private EncryptionThread[] m_arEncryptionThreads;
    private Object m_oSyncEncryptionThreads = new Object();
    private int m_OpadIndex = 0;
    private volatile boolean[] m_arRunningThread;
    private volatile int m_iRunningEncryptionThreads;

    private synchronized void incRunningEncryptionthreads() {
        ++this.m_iRunningEncryptionThreads;
    }

    private synchronized void decRunningEncryptionthreads() {
        --this.m_iRunningEncryptionThreads;
    }

    public SymCipherMultithreadedCTR() {
        int i;
        try {
            this.m_aesEngine1 = Cipher.getInstance("AES/ECB/NoPadding");
            this.m_aesEngine2 = Cipher.getInstance("AES/ECB/NoPadding");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_aesKeys = null;
        this.m_iv1 = new byte[16];
        for (i = 0; i < 16; ++i) {
            this.m_iv1[i] = 0;
        }
        this.m_iv2 = new byte[16];
        for (i = 0; i < 16; ++i) {
            this.m_iv2[i] = 0;
        }
    }

    public synchronized int setEncryptionKeyAES(byte[] key) {
        return this.setEncryptionKeyAES(key, 0, 16);
    }

    public synchronized int setEncryptionKeyAES(byte[] key, int offset, int len) {
        try {
            this.m_aesKeys = new byte[16];
            System.arraycopy(key, offset, this.m_aesKeys, 0, 16);
            if (len == 16) {
                int i;
                this.m_arCounters1 = new byte[65536];
                this.m_arOpads1 = new byte[65536];
                int b = 0;
                for (i = 3; i < 4096; i += 4) {
                    this.m_arCounters1[i] = (byte)b;
                    ++b;
                }
                for (i = 0; i < 16; ++i) {
                    this.m_iv1[i] = 0;
                    this.m_iv2[i] = 0;
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    this.m_iv1[i] = key[i + 16 + offset];
                    this.m_iv2[i] = key[i + 16 + offset];
                }
            }
            SecretKeySpec aesKey1 = new SecretKeySpec(this.m_aesKeys, "AES");
            SecretKeySpec aesKey2 = new SecretKeySpec(this.m_aesKeys, "AES");
            this.m_aesEngine1.init(1, aesKey1);
            this.m_aesEngine2.init(1, aesKey2);
            this.m_arEncryptionThreads = new EncryptionThread[this.m_nrThreads];
            this.m_arRunningThread = new boolean[this.m_arEncryptionThreads.length];
            int lowerIndex = 0;
            this.m_iOpadPerThread = 65536 / this.m_arEncryptionThreads.length;
            for (int i = 0; i < this.m_arEncryptionThreads.length; ++i) {
                SecretKeySpec aesKey = new SecretKeySpec(this.m_aesKeys, "AES");
                this.m_arRunningThread[i] = true;
                this.m_arEncryptionThreads[i] = new EncryptionThread(this.m_aesEngine1, this.m_arCounters1, this.m_arOpads1, lowerIndex, this.m_iOpadPerThread);
                lowerIndex += this.m_iOpadPerThread;
                this.m_arEncryptionThreads[i].start();
            }
            return 0;
        }
        catch (Exception e) {
            this.m_aesKeys = null;
            return -1;
        }
    }

    public synchronized int setEncryptionKeysAES(byte[] keys) {
        try {
            if (keys.length == 16) {
                return this.setEncryptionKeyAES(keys);
            }
            this.m_aesKeys = new byte[32];
            System.arraycopy(keys, 0, this.m_aesKeys, 0, 32);
            for (int i = 0; i < 16; ++i) {
                this.m_iv1[i] = 0;
                this.m_iv2[i] = 0;
            }
            SecretKeySpec aesKey1 = new SecretKeySpec(this.m_aesKeys, 0, 16, "AES");
            SecretKeySpec aesKey2 = new SecretKeySpec(this.m_aesKeys, 16, 16, "AES");
            this.m_aesEngine1.init(1, aesKey1);
            this.m_aesEngine2.init(1, aesKey2);
            return 0;
        }
        catch (Exception e) {
            this.m_aesKeys = null;
            return -1;
        }
    }

    public byte[] getKeys() {
        return this.m_aesKeys;
    }

    public synchronized void setIV2(byte[] buff) {
        for (int i = 0; i < 16; ++i) {
            this.m_iv2[i] = buff[i];
        }
        IvParameterSpec ivSpec2 = new IvParameterSpec(this.m_iv2);
        SecretKeySpec aesKey2 = this.m_aesKeys.length == 16 ? new SecretKeySpec(this.m_aesKeys, "AES") : new SecretKeySpec(this.m_aesKeys, 16, 16, "AES");
        try {
            this.m_aesEngine2.init(2, (Key)aesKey2, ivSpec2);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
    }

    public int encryptAES1(byte[] from, int ifrom, byte[] to, int ito, int len) {
        try {
            while (len > 0) {
                int remainingOpad = this.m_iOpadPerThread - this.m_OpadIndex % this.m_iOpadPerThread;
                int nrThread = this.m_OpadIndex / this.m_iOpadPerThread;
                int l = Math.min(remainingOpad, len);
                this.m_arEncryptionThreads[nrThread].waitForEncryptionFinished();
                for (int i = l; i > 0; --i) {
                    to[ito++] = (byte)(from[ifrom++] ^ this.m_arOpads1[this.m_OpadIndex++]);
                }
                len -= l;
                if ((remainingOpad -= l) == 0) {
                    this.m_arEncryptionThreads[nrThread].continueEncryption();
                }
                if (this.m_OpadIndex != 65536) continue;
                this.m_OpadIndex = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int encryptAES2(byte[] buff) {
        try {
            int len = buff.length;
            this.m_aesEngine2.update(buff, 0, len, buff, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void main(String[] argv) {
        byte[] k = new byte[16];
        byte[] inBuff = new byte[1600];
        byte[] outBuff = new byte[1600];
        byte[] outBuff2 = new byte[1600];
        SymCipherMultithreadedCTR c5 = new SymCipherMultithreadedCTR();
        c5.setEncryptionKeyAES(k);
        long l1 = System.currentTimeMillis();
        c5.setEncryptionKeyAES(k);
        for (int i = 0; i < 10000000; ++i) {
            c5.encryptAES1(inBuff, 0, outBuff, 0, 1600);
        }
        long l2 = System.currentTimeMillis();
        System.out.println("System Multithreaded CTR mode encryption takes: " + (l2 - l1) + " ms");
        Object o = new Object();
    }

    private class EncryptionThread
    implements Runnable {
        private byte[] m_arCounters;
        private byte[] m_arOpads;
        private int m_lowerIndex;
        private int m_Len;
        private volatile boolean m_bRun;
        private Cipher m_aesEngine;
        private Thread m_Thread;
        private Object m_oSync;
        private volatile boolean m_bFinished;

        protected EncryptionThread(Cipher aesEngine, byte[] counters, byte[] opads, int lowerIndex, int len) {
            this.m_arCounters = counters;
            this.m_arOpads = opads;
            this.m_lowerIndex = lowerIndex;
            this.m_Len = len;
            this.m_aesEngine = aesEngine;
            this.m_oSync = new Object();
            this.m_bFinished = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int lowerArrayIndex = this.m_lowerIndex;
            while (this.m_bRun) {
                try {
                    this.m_aesEngine.update(this.m_arCounters, lowerArrayIndex, this.m_Len, this.m_arOpads, lowerArrayIndex);
                    Object object = this.m_oSync;
                    synchronized (object) {
                        this.m_bFinished = true;
                        this.m_oSync.notify();
                    }
                    object = this.m_oSync;
                    synchronized (object) {
                        this.m_oSync.wait();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        protected synchronized void start() {
            this.m_bRun = true;
            this.m_Thread = new Thread((Runnable)this, "Multihreads Sym CTR - Encryption Thread");
            this.m_Thread.setDaemon(true);
            this.m_Thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void stop() {
            this.m_bRun = false;
            Object object = SymCipherMultithreadedCTR.this.m_oSyncEncryptionThreads;
            synchronized (object) {
                SymCipherMultithreadedCTR.this.m_oSyncEncryptionThreads.notifyAll();
            }
            try {
                this.m_Thread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void waitForEncryptionFinished() {
            Object object = this.m_oSync;
            synchronized (object) {
                while (!this.m_bFinished) {
                    try {
                        this.m_oSync.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void continueEncryption() {
            Object object = this.m_oSync;
            synchronized (object) {
                this.m_bFinished = false;
                this.m_oSync.notify();
            }
        }
    }
}

