/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.JAPCertificate;
import java.util.Vector;

public class CertPathInfo {
    private JAPCertificate m_firstCert;
    private JAPCertificate m_secondCert;
    private JAPCertificate m_rootCert;
    private Vector m_subCACerts;
    private int m_errorPosition = Integer.MAX_VALUE;
    private int m_docType;
    public static final int VERIFIED_NO_ERROR = -1;
    public static final int UNVERIFIED = Integer.MAX_VALUE;

    public CertPathInfo(JAPCertificate a_firstCert, JAPCertificate a_secondCert, JAPCertificate a_rootCert, Vector a_subCACerts, int a_docType) {
        this.m_firstCert = a_firstCert;
        this.m_secondCert = a_secondCert;
        this.m_rootCert = a_rootCert;
        this.m_subCACerts = a_subCACerts;
    }

    public void setVerified(int a_errorPosition) {
        this.m_errorPosition = a_errorPosition;
    }

    public boolean isVerified(int a_certPosition) {
        return this.m_errorPosition < a_certPosition;
    }

    public JAPCertificate getFirstCertificate() {
        return this.m_firstCert;
    }

    public JAPCertificate getSecondCertificate() {
        return this.m_secondCert;
    }

    public JAPCertificate getRootCertificate() {
        return this.m_rootCert;
    }

    public Vector getSubCACerts() {
        return this.m_subCACerts;
    }

    public int getDocType() {
        return this.m_docType;
    }

    public int getlength() {
        int len = 0;
        if (this.m_firstCert != null) {
            ++len;
        }
        if (this.m_secondCert != null) {
            ++len;
        }
        if (this.m_rootCert != null) {
            ++len;
        }
        if (this.m_subCACerts != null) {
            len += this.m_subCACerts.size();
        }
        return len;
    }

    public String toString() {
        String info = new String();
        String tab = "\t";
        if (this.m_rootCert != null) {
            info = info + this.m_rootCert.getSubject().getCommonName() + "\n";
        }
        if (this.m_subCACerts != null) {
            for (int i = this.m_subCACerts.size() - 1; i >= 0; --i) {
                info = info + tab + ((JAPCertificate)this.m_subCACerts.elementAt(i)).getSubject().getCommonName() + "\n";
                tab = tab + tab;
            }
        }
        if (this.m_secondCert != null) {
            info = info + tab + this.m_secondCert.getSubject().getCommonName() + "\n";
            tab = tab + tab;
        }
        if (this.m_firstCert != null) {
            info = info + tab + this.m_firstCert.getSubject().getCommonName() + "\n";
        }
        return info;
    }
}

