/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.MyDSAPrivateKey;
import java.security.SecureRandom;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.DSAParametersGenerator;
import org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;

public class DSAKeyPair
extends AsymmetricCryptoKeyPair {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$security$SecureRandom;

    public DSAKeyPair(MyDSAPrivateKey a_privateKey) {
        super(a_privateKey);
    }

    public static DSAKeyPair getInstance(SecureRandom a_secureRandom, int a_keyLength, int a_certainty) {
        DSAKeyPair keyPair = DSAKeyPair.getInstanceJCE(a_secureRandom, a_keyLength, a_certainty);
        if (keyPair == null) {
            DSAParametersGenerator dsaParametersGenerator = new DSAParametersGenerator();
            dsaParametersGenerator.init(a_keyLength, a_certainty, a_secureRandom);
            DSAKeyPairGenerator dsaKeyPairGenerator = new DSAKeyPairGenerator();
            dsaKeyPairGenerator.init(new DSAKeyGenerationParameters(a_secureRandom, dsaParametersGenerator.generateParameters()));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = dsaKeyPairGenerator.generateKeyPair();
            try {
                keyPair = new DSAKeyPair(new MyDSAPrivateKey((DSAPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
            }
            catch (Exception a_e) {
                keyPair = null;
            }
        }
        if (!AsymmetricCryptoKeyPair.isValidKeyPair(keyPair)) {
            return null;
        }
        return keyPair;
    }

    private static DSAKeyPair getInstanceJCE(SecureRandom a_secureRandom, int a_keyLength, int a_certainty) {
        DSAKeyPair keyPair;
        try {
            Class<?> classKeyPairGenerator = Class.forName("java.security.KeyPairGenerator");
            Class<?> classKeyPair = Class.forName("java.security.KeyPair");
            Class<?> classDSAUtil = Class.forName("org.bouncycastle.jce.provider.DSAUtil");
            Class<?> classPrivateKey = Class.forName("java.security.PrivateKey");
            Object kg = classKeyPairGenerator.getMethod("getInstance", class$java$lang$String == null ? (class$java$lang$String = DSAKeyPair.class$("java.lang.String")) : class$java$lang$String).invoke(classKeyPairGenerator, "DSA");
            classKeyPairGenerator.getMethod("initialize", Integer.TYPE, class$java$security$SecureRandom == null ? (class$java$security$SecureRandom = DSAKeyPair.class$("java.security.SecureRandom")) : class$java$security$SecureRandom).invoke(kg, new Integer(a_keyLength), a_secureRandom);
            Object jceKeyPair = classKeyPairGenerator.getMethod("generateKeyPair", null).invoke(kg, (Object[])null);
            Object jcePrivateKey = classKeyPair.getMethod("getPrivate", null).invoke(jceKeyPair, (Object[])null);
            DSAPrivateKeyParameters dsaParameters = (DSAPrivateKeyParameters)classDSAUtil.getMethod("generatePrivateKeyParameter", classPrivateKey).invoke(classDSAUtil, jcePrivateKey);
            try {
                keyPair = new DSAKeyPair(new MyDSAPrivateKey(dsaParameters));
                LogHolder.log(6, LogType.CRYPTO, "Used JCE for creating DSA key pair.");
            }
            catch (Exception a_e) {
                keyPair = null;
            }
            if (keyPair != null && !AsymmetricCryptoKeyPair.isValidKeyPair(keyPair)) {
                LogHolder.log(3, LogType.CRYPTO, "Created illegal DSA certificate with JCE!");
                keyPair = null;
            }
        }
        catch (ClassNotFoundException a_e) {
            LogHolder.log(7, LogType.CRYPTO, "Optional class was not loaded: " + a_e.getMessage());
            keyPair = null;
        }
        catch (NoSuchMethodException a_e) {
            LogHolder.log(7, LogType.CRYPTO, a_e);
            keyPair = null;
        }
        catch (Exception a_e) {
            LogHolder.log(3, LogType.CRYPTO, "Could not create DSA certificate with JCE!", a_e);
            keyPair = null;
        }
        return keyPair;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

