/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractPublicKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.ISignatureVerificationAlgorithm;
import anon.crypto.MyECDSASignature;
import anon.crypto.MyECParams;
import java.security.InvalidKeyException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class MyECPublicKey
extends AbstractPublicKey
implements IMyPublicKey {
    private static final long serialVersionUID = 1L;
    private X9ECPoint m_Q;
    private MyECParams m_params;

    public MyECPublicKey(ECPublicKeyParameters params) {
        this.m_Q = new X9ECPoint(params.getQ(), false);
        this.m_params = new MyECParams(params.getParameters());
    }

    public MyECPublicKey(SubjectPublicKeyInfo spki) throws IllegalArgumentException {
        try {
            DERBitString derBits = spki.getPublicKeyData();
            DEROctetString derQ = new DEROctetString(derBits.getBytes());
            this.m_params = new MyECParams(X962Parameters.getInstance(spki.getAlgorithmId().getParameters()));
            this.m_Q = new X9ECPoint(this.m_params.getECDomainParams().getCurve(), derQ);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid info structure in ECDSA public key");
        }
    }

    public boolean equals(Object a_publicKey) {
        if (a_publicKey == null) {
            return false;
        }
        if (!(a_publicKey instanceof ECPublicKeyParameters)) {
            return false;
        }
        ECPublicKeyParameters e = (ECPublicKeyParameters)a_publicKey;
        if (e.getQ().equals(this.m_Q.getPoint())) {
            return false;
        }
        return this.m_params.equals(e.getParameters());
    }

    public int hashCode() {
        return 0;
    }

    public SubjectPublicKeyInfo getAsSubjectPublicKeyInfo() {
        AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, this.m_params.getX962Params().toASN1Object());
        return new SubjectPublicKeyInfo(algId, this.m_Q.getPoint().getEncoded(false));
    }

    public int getKeyLength() {
        return this.m_params.getECDomainParams().getN().bitLength() - 1;
    }

    public ISignatureVerificationAlgorithm getSignatureAlgorithm() {
        try {
            MyECDSASignature algorithm = new MyECDSASignature();
            algorithm.initVerify(this);
            return algorithm;
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
    }

    public ECPublicKeyParameters getPublicParams() {
        return new ECPublicKeyParameters(this.m_Q.getPoint(), this.m_params.getECDomainParams());
    }

    public String getAlgorithm() {
        return "Elliptic Curve Cryptography";
    }

    public String getFormat() {
        return "X509";
    }

    public Element toXmlElement(Document a_doc) {
        return null;
    }

    protected void setNamedCurveID(ASN1ObjectIdentifier curveIdentifier) {
        this.m_params.setNamedCurveID(curveIdentifier);
    }
}

