/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

public abstract class AbstractDatabaseEntry {
    public static final String XML_LAST_UPDATE = "LastUpdate";
    public static final String XML_ATTR_LAST_UPDATE = "lastUpdate";
    private long m_expireTime;
    private long m_creationTime;

    public AbstractDatabaseEntry(long a_expireTime) {
        this.m_expireTime = a_expireTime;
        this.m_creationTime = System.currentTimeMillis();
    }

    public final boolean isNewerThan(AbstractDatabaseEntry a_oldEntry) {
        return a_oldEntry == null || this.getVersionNumber() > a_oldEntry.getVersionNumber() || (this.getLastUpdate() > a_oldEntry.getLastUpdate() || this.getLastUpdate() == 0L && a_oldEntry.getLastUpdate() == 0L) && this.getVersionNumber() == a_oldEntry.getVersionNumber();
    }

    public boolean isUserDefined() {
        return false;
    }

    public boolean isPersistanceDeletionAllowed() {
        return false;
    }

    public void deletePersistence() {
    }

    public abstract String getId();

    public final long getExpireTime() {
        return this.m_expireTime;
    }

    public final void setExpireTime(long a_expireTime) {
        this.m_expireTime = a_expireTime;
    }

    public abstract long getLastUpdate();

    public final long getCreationTime() {
        return this.m_creationTime;
    }

    public final void resetCreationTime() {
        this.m_creationTime = System.currentTimeMillis();
    }

    public abstract long getVersionNumber();
}

