/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.NVPair;
import HTTPClient.SocksException;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.ListenerInterface;
import anon.infoservice.ProxyInterface;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class HTTPConnectionFactory {
    public static final int HTTP_ENCODING_PLAIN = 0;
    public static final int HTTP_ENCODING_ZLIB = 1;
    public static final int HTTP_ENCODING_GZIP = 2;
    public static final String HTTP_ENCODING_ZLIB_STRING = "deflate";
    public static final String HTTP_ENCODING_GZIP_STRING = "gzip";
    private static Class ms_HTTPConnectionClass = class$HTTPClient$HTTPConnection == null ? (class$HTTPClient$HTTPConnection = HTTPConnectionFactory.class$("HTTPClient.HTTPConnection")) : class$HTTPClient$HTTPConnection;
    private static HTTPConnectionFactory ms_httpConnectionFactoryInstance;
    private Vector m_vecHTTPConnections;
    private int m_timeout;
    private ImmutableProxyInterface m_proxyInterface;
    private boolean m_bUseAuth = false;
    private Class m_classHTTPCLient_ContentEncodingeModule;
    static /* synthetic */ Class class$HTTPClient$HTTPConnection;
    static /* synthetic */ Class class$java$lang$String;

    private HTTPConnectionFactory() {
        this.setNewProxySettings(null, false);
        this.m_timeout = 10;
        try {
            this.m_classHTTPCLient_ContentEncodingeModule = Class.forName("HTTPClient.ContentEncodingModule");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static HTTPConnectionFactory getInstance() {
        block0: {
            if (ms_httpConnectionFactoryInstance != null) break block0;
            ms_httpConnectionFactoryInstance = new HTTPConnectionFactory();
        }
        return ms_httpConnectionFactoryInstance;
    }

    public synchronized void setNewProxySettings(ImmutableProxyInterface a_proxyInterface, boolean a_bUseAuth) {
        this.m_proxyInterface = a_proxyInterface;
        this.m_bUseAuth = a_bUseAuth;
        if (a_proxyInterface == null || !a_proxyInterface.isValid()) {
            this.m_proxyInterface = null;
            HTTPConnection.setProxyServer(null, -1);
            HTTPConnection.setSocksServer(null, -1);
            return;
        }
        if (a_proxyInterface.getProtocol() == 1) {
            HTTPConnection.setProxyServer(a_proxyInterface.getHost(), a_proxyInterface.getPort());
            HTTPConnection.setSocksServer(null, -1);
        } else if (a_proxyInterface.getProtocol() == 3) {
            HTTPConnection.setProxyServer(null, -1);
            try {
                HTTPConnection.setSocksServer(a_proxyInterface.getHost(), a_proxyInterface.getPort(), 5);
            }
            catch (SocksException e) {
                // empty catch block
            }
            if (this.m_bUseAuth) {
                NVPair[] up = new NVPair[]{new NVPair(a_proxyInterface.getAuthenticationUserID(), a_proxyInterface.getAuthenticationPassword())};
                AuthorizationInfo.addAuthorization(new AuthorizationInfo(a_proxyInterface.getHost(), a_proxyInterface.getPort(), "SOCKS5", "USER/PASS", up, null));
            }
        }
    }

    public synchronized void setTimeout(int a_timeout) {
        if (a_timeout < 0) {
            a_timeout = 0;
        }
        this.m_timeout = a_timeout;
    }

    public synchronized int getTimeout() {
        return this.m_timeout;
    }

    public synchronized HTTPConnection createHTTPConnection(ListenerInterface target) {
        return this.createHTTPConnection(target, 0, true, null);
    }

    public synchronized HTTPConnection createHTTPConnection(ListenerInterface target, int a_encoding, boolean a_bGet) {
        return this.createHTTPConnection(target, a_encoding, a_bGet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HTTPConnection createHTTPConnection(ListenerInterface target, int a_encoding, boolean a_bGet, Vector a_vecNVPairHeaderReplacements) {
        HTTPConnection newConnection = null;
        Object object = this;
        synchronized (object) {
            newConnection = this.createHTTPConnectionInternal(target);
            if (this.m_proxyInterface != null && this.m_proxyInterface.isAuthenticationUsed()) {
                DefaultAuthHandler.setAuthorizationPrompter(new AuthorizationPrompter(){
                    boolean bAlreadyTried = false;
                    String password;

                    public synchronized NVPair getUsernamePassword(AuthorizationInfo challenge) {
                        try {
                            this.password = HTTPConnectionFactory.this.m_proxyInterface.getAuthenticationPassword();
                            if (this.password == null) {
                                return null;
                            }
                            if (this.bAlreadyTried) {
                                if (HTTPConnectionFactory.this.m_proxyInterface instanceof ProxyInterface) {
                                    ((ProxyInterface)HTTPConnectionFactory.this.m_proxyInterface).clearAuthenticationPassword();
                                } else {
                                    return null;
                                }
                            }
                            this.bAlreadyTried = true;
                            return new NVPair(HTTPConnectionFactory.this.m_proxyInterface.getAuthenticationUserID(), this.password);
                        }
                        catch (Exception a_e) {
                            LogHolder.log(2, LogType.NET, a_e);
                            return null;
                        }
                    }
                });
            }
        }
        HTTPConnectionFactory.replaceHeader(newConnection, new NVPair("Cache-Control", "no-cache"));
        HTTPConnectionFactory.replaceHeader(newConnection, new NVPair("Pragma", "no-cache"));
        if (a_vecNVPairHeaderReplacements != null) {
            object = a_vecNVPairHeaderReplacements;
            synchronized (object) {
                for (int i = 0; i < a_vecNVPairHeaderReplacements.size(); ++i) {
                    HTTPConnectionFactory.replaceHeader(newConnection, (NVPair)a_vecNVPairHeaderReplacements.elementAt(i));
                }
            }
        }
        if (a_encoding != 0) {
            if ((a_encoding & 1) > 0) {
                if (a_bGet) {
                    newConnection.addModule(this.m_classHTTPCLient_ContentEncodingeModule, -1);
                } else {
                    newConnection.removeModule(this.m_classHTTPCLient_ContentEncodingeModule);
                    HTTPConnectionFactory.replaceHeader(newConnection, new NVPair("Content-Encoding", HTTP_ENCODING_ZLIB_STRING));
                }
            }
        } else {
            newConnection.removeModule(this.m_classHTTPCLient_ContentEncodingeModule);
        }
        newConnection.setTimeout(this.getTimeout() * 1000);
        return newConnection;
    }

    public synchronized HTTPConnection createHTTPConnection(ListenerInterface target, ImmutableProxyInterface a_proxySettings) {
        return this.createHTTPConnection(target, a_proxySettings, 0, true, null);
    }

    public synchronized HTTPConnection createHTTPConnection(ListenerInterface target, ImmutableProxyInterface a_proxySettings, int a_encoding, boolean a_bGet, Vector a_vecNVPairHeaderReplacements) {
        ImmutableProxyInterface oldProxySettings = this.m_proxyInterface;
        this.setNewProxySettings(a_proxySettings, this.m_bUseAuth);
        HTTPConnection createdConnection = this.createHTTPConnection(target, a_encoding, a_bGet, a_vecNVPairHeaderReplacements);
        this.setNewProxySettings(oldProxySettings, this.m_bUseAuth);
        return createdConnection;
    }

    private static void replaceHeader(HTTPConnection connection, NVPair header) {
        NVPair[] headers = connection.getDefaultHeaders();
        if (headers == null || headers.length == 0) {
            headers = new NVPair[]{header};
            connection.setDefaultHeaders(headers);
        } else {
            for (int i = 0; i < headers.length; ++i) {
                if (!headers[i].getName().equalsIgnoreCase(header.getName())) continue;
                headers[i] = header;
                connection.setDefaultHeaders(headers);
                return;
            }
            NVPair[] tmpHeaders = new NVPair[headers.length + 1];
            System.arraycopy(headers, 0, tmpHeaders, 0, headers.length);
            tmpHeaders[headers.length] = header;
            connection.setDefaultHeaders(tmpHeaders);
        }
    }

    private static void setHTTPConnectionClass(Class a_HTTPConnectionClass) {
        if (!(class$HTTPClient$HTTPConnection == null ? (class$HTTPClient$HTTPConnection = HTTPConnectionFactory.class$("HTTPClient.HTTPConnection")) : class$HTTPClient$HTTPConnection).isAssignableFrom(a_HTTPConnectionClass)) {
            throw new IllegalArgumentException("This is not a valid HTTPConnection class: " + a_HTTPConnectionClass);
        }
        ms_httpConnectionFactoryInstance = null;
        ms_HTTPConnectionClass = a_HTTPConnectionClass;
    }

    private Vector getCreatedHTTPConnections() {
        return this.m_vecHTTPConnections;
    }

    private HTTPConnection createHTTPConnectionInternal(ListenerInterface target) {
        HTTPConnection connection;
        if (ms_HTTPConnectionClass == (class$HTTPClient$HTTPConnection == null ? (class$HTTPClient$HTTPConnection = HTTPConnectionFactory.class$("HTTPClient.HTTPConnection")) : class$HTTPClient$HTTPConnection)) {
            connection = new HTTPConnection(target.getHost(), target.getPort());
        } else {
            Class[] paramTypes = new Class[2];
            Object[] params = new Object[2];
            paramTypes[0] = class$java$lang$String == null ? (class$java$lang$String = HTTPConnectionFactory.class$("java.lang.String")) : class$java$lang$String;
            paramTypes[1] = Integer.TYPE;
            params[0] = target.getHost();
            params[1] = new Integer(target.getPort());
            try {
                connection = (HTTPConnection)ms_HTTPConnectionClass.getConstructor(paramTypes).newInstance(params);
            }
            catch (Exception a_e) {
                throw new IllegalArgumentException("Could not construct an HTTPConnection! " + a_e);
            }
            if (this.m_vecHTTPConnections == null) {
                this.m_vecHTTPConnections = new Vector();
            }
            this.m_vecHTTPConnections.addElement(connection);
        }
        return connection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

