/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.mixminion.fec.FECCode;
import anon.mixminion.fec.FECCodeFactory;
import anon.mixminion.message.ExitInformation;
import anon.mixminion.message.Message;
import anon.mixminion.message.MessageImplementation;
import anon.mixminion.message.MixMinionCryptoUtil;
import anon.mixminion.mmrdescription.MMRDescription;
import anon.util.ByteArrayUtil;
import logging.LogHolder;
import logging.LogType;

public class FragmentedMessage
extends MessageImplementation {
    static final int KEY_LEN = 16;
    static final int OVERHEAD = 0;
    static final int FRAGMENT_HEADER_LEN = 47;
    String[] m_recipient;
    byte[] m_payload;

    public FragmentedMessage(String[] recipient, byte[] payload) {
        this.m_payload = payload;
        this.m_recipient = recipient;
    }

    public byte[][] buildPayload() {
        this.m_payload = MixMinionCryptoUtil.compressData(this.m_payload);
        ExitInformation pl_exit_info = MMRDescription.getExitInformation(this.m_recipient, null);
        pl_exit_info.m_Content = this.m_recipient[0].getBytes();
        byte[] prepayload = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(256L, 2), ByteArrayUtil.inttobyte(pl_exit_info.m_Content.length, 2), pl_exit_info.m_Content);
        this.m_payload = ByteArrayUtil.conc(prepayload, this.m_payload);
        LogHolder.log(7, LogType.MISC, "[Message] Fragmented, new Compressed Size = " + this.m_payload.length);
        if (this.m_payload.length + 22 <= Message.BLOCK_SIZE) {
            throw new RuntimeException("Fragmented Header nach Neukomprimierung mit Single-Laenge");
        }
        this.m_payload = this.whiten(this.m_payload);
        byte[][] frags = this.divideIntoFragments(this.m_payload);
        byte[] id = MixMinionCryptoUtil.randomArray(20);
        byte[] sz = ByteArrayUtil.inttobyte(this.m_payload.length, 4);
        byte[][] payloads = new byte[frags.length][Message.BLOCK_SIZE];
        for (int i = 0; i < frags.length; ++i) {
            byte[] actual_fragment = frags[i];
            byte[] flag = new byte[3];
            flag = ByteArrayUtil.inttobyte(0x800000 + i, 3);
            byte[] hash2 = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(id, sz, actual_fragment));
            payloads[i] = ByteArrayUtil.conc(flag, hash2, id, sz, actual_fragment);
        }
        return payloads;
    }

    byte[][] divideIntoFragments(byte[] payload) {
        int packet_size = Message.BLOCK_SIZE - 47 - 0;
        double payload_packets = Math.ceil((double)payload.length / (double)packet_size);
        double tmp = Math.log(payload_packets) / Math.log(2.0);
        tmp = Math.ceil(tmp);
        tmp = Math.pow(2.0, tmp);
        int k = (int)Math.min(16.0, tmp);
        int overall_packets = (int)Math.ceil(payload_packets / (double)k);
        byte[] random = MixMinionCryptoUtil.randomArray(16);
        int len = payload.length - overall_packets * packet_size * k;
        System.out.println(len);
        len = Math.abs(len);
        byte[] padding = MixMinionCryptoUtil.createPRNG(random, len);
        payload = ByteArrayUtil.conc(payload, padding);
        byte[][] packets = new byte[overall_packets][packet_size];
        for (int i = 1; i <= overall_packets; ++i) {
            byte[] b = ByteArrayUtil.copy(payload, (i - 1) * packet_size * k, packet_size * k);
            packets[i - 1] = b;
        }
        int N = (int)Math.ceil(Message.EXP_FACTOR * (double)k);
        System.out.println("   N,num " + N + " " + overall_packets);
        byte[][] FRAGMENTS = new byte[overall_packets * N][Message.BLOCK_SIZE];
        for (int i = 0; i <= overall_packets - 1; ++i) {
            for (int j = 0; j <= N - 1; ++j) {
                FRAGMENTS[i * N + j] = this.FRAGMENT(packets[i], k, N, j, packet_size);
            }
        }
        return FRAGMENTS;
    }

    byte[] FRAGMENT(byte[] M, int K, int N, int I, int PS) {
        int i;
        int packetsize = PS;
        byte[] source = M;
        byte[] repair = new byte[N * packetsize];
        byte[][] sourceBuffer = new byte[K][];
        byte[][] repairBuffer = new byte[N][];
        int[] srcOffs = new int[sourceBuffer.length];
        int[] repairOffs = new int[repairBuffer.length];
        for (i = 0; i < sourceBuffer.length; ++i) {
            sourceBuffer[i] = source;
            srcOffs[i] = i * packetsize;
        }
        for (i = 0; i < repairBuffer.length; ++i) {
            repairBuffer[i] = repair;
            repairOffs[i] = i * packetsize;
        }
        int[] repairIndex = new int[N];
        for (int i2 = 0; i2 < repairIndex.length; ++i2) {
            repairIndex[i2] = i2;
        }
        FECCode fec = FECCodeFactory.getDefault().createFECCode(K, N);
        fec.encode(sourceBuffer, srcOffs, repairBuffer, repairOffs, repairIndex, packetsize);
        return ByteArrayUtil.copy(repairBuffer[I], repairOffs[I], packetsize);
    }

    private byte[] whiten(byte[] m) {
        byte[] k_whiten = new byte[]{87, 72, 73, 84, 69, 78};
        byte[] valuetohash = ByteArrayUtil.conc(k_whiten, "WHITEN".getBytes());
        return MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(valuetohash), m);
    }
}

