/*
 * Decompiled with CFR 0.152.
 */
package anon.transport.address;

import anon.transport.address.AddressMappingException;
import anon.transport.address.AddressParameter;
import anon.transport.address.Endpoint;
import anon.transport.address.IAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class TcpIpAddress
implements IAddress {
    public static final String TRANSPORT_IDENTIFIER = "tcpip";
    private static final String IP_PARAMETER = "ip-address";
    private static final String PORT_PARAMETER = "port";
    protected int m_port;
    protected InetAddress m_ipAddress;

    public TcpIpAddress(String a_host, int a_port) {
        try {
            this.m_ipAddress = InetAddress.getByName(a_host);
        }
        catch (UnknownHostException e) {
            this.m_ipAddress = null;
        }
        this.m_port = a_port;
    }

    public TcpIpAddress(InetAddress a_ipAddress, int a_port) {
        this.m_ipAddress = a_ipAddress;
        this.m_port = a_port;
    }

    public TcpIpAddress(Endpoint a_baseAddress) throws AddressMappingException {
        String value = a_baseAddress.getParameter(IP_PARAMETER);
        if (value == null) {
            throw new AddressMappingException("IP Parameter is missing");
        }
        try {
            this.m_ipAddress = InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new AddressMappingException("IP-Address could not be parsed.");
        }
        value = a_baseAddress.getParameter(PORT_PARAMETER);
        if (value == null) {
            throw new AddressMappingException("Port Parameter is missing");
        }
        try {
            this.m_port = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new AddressMappingException("Port could not be parsed.");
        }
    }

    public InetAddress getIPAddress() {
        return this.m_ipAddress;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getHostname() {
        return this.m_ipAddress.getHostName();
    }

    public AddressParameter[] getAllParameters() {
        AddressParameter[] result = new AddressParameter[]{new AddressParameter(IP_PARAMETER, this.m_ipAddress.getHostAddress()), new AddressParameter(PORT_PARAMETER, String.valueOf(this.m_port))};
        return result;
    }

    public String getTransportIdentifier() {
        return TRANSPORT_IDENTIFIER;
    }
}

