/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.multicast;

import infoservice.agreement.logging.IAgreementLog;
import infoservice.agreement.multicast.interfaces.IAgreementHandler;
import infoservice.agreement.multicast.interfaces.IAgreementMessage;
import infoservice.agreement.multicast.interfaces.IInfoService;
import infoservice.dynamic.DynamicConfiguration;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class AbstractEMCAdapter
implements IInfoService {
    protected IAgreementHandler m_agreementHandler;
    protected boolean m_activeAgreementStarted = false;
    private boolean doNotHandleAnything = true;
    private boolean m_mustBeRestartedForSecurityReason = true;
    protected IAgreementLog m_log;
    private boolean m_beInPassiveMode;

    public AbstractEMCAdapter(IAgreementLog a_log) {
        this.m_log = a_log;
    }

    public void setIAgreementHandler(IAgreementHandler p_agreementhandler) {
        this.m_agreementHandler = p_agreementhandler;
        this.m_agreementHandler.setLog(this.m_log);
    }

    public void startAdapter() {
        this.info("AgreementAdapter has been started ...");
        this.reset();
        new Thread("AbstractEMCAdapter - startAdapter()"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                        AbstractEMCAdapter.this.tryToStartAgreementMinute();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }.start();
    }

    protected void tryToStartAgreementMinute() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("CET"));
        int hour = DynamicConfiguration.getInstance().getHourOfAgreement();
        int passive = (int)(DynamicConfiguration.getInstance().getPassivePhaseLength() / 1000L / 60L);
        if (c.get(12) % hour >= hour - passive && !this.m_activeAgreementStarted && !this.m_beInPassiveMode) {
            this.startListeningMode();
            return;
        }
        if (c.get(12) % hour == 0 && !this.m_activeAgreementStarted && this.m_beInPassiveMode) {
            this.startAgreementCommitmentProtocol();
            return;
        }
    }

    protected void tryToStartAgreementHour() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("CET"));
        int hour = DynamicConfiguration.getInstance().getHourOfAgreement();
        int passive = (int)(DynamicConfiguration.getInstance().getPassivePhaseLength() / 1000L / 60L);
        if (c.get(11) == hour - 1 && c.get(12) >= 60 - passive && !this.m_activeAgreementStarted && !this.m_beInPassiveMode) {
            this.startListeningMode();
            return;
        }
        if (c.get(11) == hour && c.get(12) == 0 && !this.m_activeAgreementStarted && this.m_beInPassiveMode) {
            this.startAgreementCommitmentProtocol();
            return;
        }
    }

    @Override
    public void handleMessage(IAgreementMessage a_msg) {
        if (this.doNotHandleAnything) {
            this.info("CAN'T HANDLE MASSAGES FOR BEEING IN STOPP-MODE.\n");
            return;
        }
        if (this.getNumberOfAllInfoservices() < 3) {
            this.info("CAN'T HANDLE MASSAGES. NUMBER OF INFOSERVICES IS TO SMALL: " + this.getNumberOfAllInfoservices() + "\n");
            return;
        }
        this.startAgreementCommitmentProtocol();
        this.m_agreementHandler.handleMessage(a_msg);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyAgreement(Long a_oldCommonRandomSeed, Long a_newCommonRandomSeed) {
        this.reset();
        this.m_mustBeRestartedForSecurityReason = a_oldCommonRandomSeed.equals(new Long(Long.parseLong("0000000000")));
        if (a_newCommonRandomSeed != null) {
            this.info("\n*********************************\nAGREEMENT REACHED: " + a_newCommonRandomSeed + "\n*********************************\n");
            if (this.m_mustBeRestartedForSecurityReason) {
                this.info("\n*********************************\nATTENTION! THE USED ROUNDNUMBER WAS THE DEFAULT ONE.  WE HAVE TO RESTART THE PROTOCOL FOR SECURITY REASONS!!!\n*********************************\n");
                this.restartAgreement();
                return;
            }
            this.buildCascades(a_newCommonRandomSeed);
        } else {
            this.info("\n*********************************\nNO AGREEMENT WAS REACHED, ABORTING\n*********************************\n");
        }
        this.info("I will be inactive until the next passive phase will be started ...\n");
    }

    private void restartAgreement() {
        this.startListeningMode();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(DynamicConfiguration.getInstance().getEmcGlobalTimeout());
                    AbstractEMCAdapter.this.startAgreementCommitmentProtocol();
                }
                catch (InterruptedException e) {
                    AbstractEMCAdapter.this.error("Unable to sleep in thread!");
                }
            }
        }.start();
    }

    public synchronized void startListeningMode() {
        this.doNotHandleAnything = false;
        this.m_activeAgreementStarted = false;
        this.m_beInPassiveMode = true;
        this.m_agreementHandler.reset();
        this.startListening();
        this.info(" START PASSIVE MODE ---> Now we are ready to start the agreement. Listening for incomming messages ...\n ");
    }

    public void startProtocolByOperator() {
        if (this.m_beInPassiveMode) {
            this.info(" STATUS PASSIVE MODE. AGREEMNET WILL BE STARTED SHORTLY BY TIMETRIGGER.\n");
            return;
        }
        if (this.m_activeAgreementStarted) {
            this.info(" CAN'T START AGREEMENT BY OPERATOR. AGREEMENT IS JUST RUNNIG!!!\n");
            return;
        }
        this.info(" TRY TO START AGREEMENT BY OPERATOR ...\n");
        this.restartAgreement();
    }

    protected synchronized void startAgreementCommitmentProtocol() {
        if (this.doNotHandleAnything) {
            this.info(" CAN'T START AGREEMENT FOR BEEING IN STOPP-MODE. TRY IT AGAIN LATER.\n");
            return;
        }
        if (this.m_activeAgreementStarted) {
            return;
        }
        if (!this.m_beInPassiveMode) {
            this.info(" CAN'T START AGREEMENT ONLY IN PASSIVE-MODE.\n");
            this.reset();
            return;
        }
        try {
            this.prepareStart();
        }
        catch (NullPointerException e) {
            this.fatal(e.getMessage());
            this.reset();
            return;
        }
        if (this.getNumberOfAllInfoservices() < 3) {
            this.info(" CAN'T START AGREEMENT FOR: Number of all available Infoservices (" + this.getNumberOfAllInfoservices() + ") are less than 3.\n");
            this.reset();
            return;
        }
        this.info(" START AGREEMENT NOW ");
        this.m_activeAgreementStarted = true;
        this.m_beInPassiveMode = false;
        this.m_agreementHandler.startAgreementCommitmentProtocol();
    }

    private void reset() {
        this.info(" INTERNAL RESET  ");
        this.doNotHandleAnything = true;
        this.m_beInPassiveMode = false;
        this.m_activeAgreementStarted = false;
    }

    protected abstract void buildCascades(long var1);

    protected abstract void startListening();

    protected abstract void prepareStart() throws NullPointerException;

    @Override
    public abstract void sendMessageTo(String var1, IAgreementMessage var2);

    @Override
    public abstract void multicastMessage(IAgreementMessage var1);

    @Override
    public abstract String getIdentifier();

    @Override
    public abstract int getNumberOfAllInfoservices();

    public void setLog(IAgreementLog a_log) {
        this.m_log = a_log;
    }

    public IAgreementLog getLog() {
        return this.m_log;
    }

    protected void debug(String a_msg) {
        this.m_log.debug(a_msg);
    }

    protected void info(String a_msg) {
        this.m_log.info(a_msg);
    }

    protected void error(String a_msg) {
        this.m_log.error(a_msg);
    }

    protected void fatal(String a_msg) {
        this.m_log.fatal(a_msg);
    }
}

