/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HttpClientUtil;
import HTTPClient.HttpOutputStreamFilter;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class HttpOutputStream
extends OutputStream
implements GlobalConstants {
    private int length;
    private int rcvd = 0;
    private Request req = null;
    private Response resp = null;
    private OutputStream os = null;
    private ByteArrayOutputStream bos = null;
    private Vector filters = new Vector();
    private int con_to = 0;
    private boolean ignore = false;
    private NVPair[] trailers = null;

    public HttpOutputStream() {
        this.length = -1;
    }

    public HttpOutputStream(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be greater equal 0");
        }
        this.length = length;
    }

    void goAhead(Request req, OutputStream os, int con_to) {
        this.req = req;
        this.con_to = con_to;
        if (os == null) {
            this.bos = new ByteArrayOutputStream();
            os = this.bos;
        }
        this.os = os;
        int num = this.filters.size();
        for (int idx = 0; idx < num; ++idx) {
            this.os = ((HttpOutputStreamFilter)this.filters.elementAt(idx)).pushStream(this.os, req);
        }
    }

    void ignoreData(Request req) {
        this.req = req;
        this.ignore = true;
    }

    synchronized Response getResponse() {
        while (this.resp == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.resp;
    }

    public int getLength() {
        return this.length;
    }

    public void write(int b) throws IOException, IllegalAccessError {
        byte[] tmp = new byte[]{(byte)b};
        this.write(tmp, 0, 1);
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException, IllegalAccessError {
        if (this.req == null) {
            throw new IllegalAccessError("Stream not associated with a request");
        }
        if (this.ignore) {
            return;
        }
        try {
            if (this.length != -1 && this.rcvd + len > this.length) {
                throw new IOException("Tried to write too many bytes (" + (this.rcvd + len) + " > " + this.length + ")");
            }
            if (this.bos != null || this.length != -1) {
                this.os.write(buf, off, len);
            } else {
                this.os.write(Codecs.chunkedEncode(buf, off, len, null, false));
            }
        }
        catch (IOException ioe) {
            this.req.getConnection().closeDemux(ioe);
            this.req.getConnection().outputFinished();
            throw ioe;
        }
        this.rcvd += len;
    }

    public synchronized void close() throws IOException, IllegalAccessError {
        if (this.req == null) {
            throw new IllegalAccessError("Stream not associated with a request");
        }
        if (this.ignore) {
            return;
        }
        if (this.bos != null) {
            this.os.close();
            this.req.setData(this.bos.toByteArray());
            this.req.setStream(null);
            if (this.trailers != null) {
                NVPair[] hdrs = this.req.getHeaders();
                int len = hdrs.length;
                for (int idx = 0; idx < len; ++idx) {
                    if (!hdrs[idx].getName().equalsIgnoreCase("Trailer")) continue;
                    System.arraycopy(hdrs, idx + 1, hdrs, idx, len - idx - 1);
                    --len;
                }
                hdrs = HttpClientUtil.resizeArray(hdrs, len + this.trailers.length);
                System.arraycopy(this.trailers, 0, hdrs, len, this.trailers.length);
                this.req.setHeaders(hdrs);
            }
            try {
                this.resp = this.req.getConnection().sendRequest(this.req, this.con_to);
            }
            catch (ModuleException me) {
                throw new IOException(me.toString());
            }
            this.notify();
        } else {
            try {
                if (this.length == -1) {
                    this.os.write(Codecs.chunkedEncode(null, 0, 0, this.trailers, true));
                } else if (this.rcvd < this.length) {
                    throw new IOException("Premature close: only " + this.rcvd + " bytes written instead of exptected " + this.length);
                }
                this.os.flush();
            }
            catch (IOException ioe) {
                this.req.getConnection().closeDemux(ioe);
                throw ioe;
            }
            finally {
                this.req.getConnection().outputFinished();
            }
        }
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public void setTrailers(NVPair[] trailers) throws IllegalAccessError, IllegalStateException {
        if (this.req == null) {
            throw new IllegalAccessError("Stream not associated with a request");
        }
        if (this.length != -1) {
            throw new IllegalStateException("Entity being sent with a Content-length");
        }
        this.trailers = new NVPair[trailers.length];
        System.arraycopy(trailers, 0, this.trailers, 0, trailers.length);
    }

    public NVPair[] getTrailers() {
        NVPair[] trls = new NVPair[this.trailers.length];
        System.arraycopy(this.trailers, 0, trls, 0, this.trailers.length);
        return trls;
    }

    public void addFilter(HttpOutputStreamFilter filter) {
        if (this.req != null) {
            throw new IllegalAccessError("Stream already bound to socket");
        }
        this.filters.addElement(filter);
    }

    public void reset() {
        this.rcvd = 0;
        this.req = null;
        this.resp = null;
        this.os = null;
        this.bos = null;
        this.filters = new Vector();
        this.con_to = 0;
        this.ignore = false;
        this.trailers = null;
    }

    public String toString() {
        return this.getClass().getName() + "[length=" + this.length + "]";
    }
}

