/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls;

import anon.crypto.IMyPrivateKey;
import anon.crypto.JAPCertificate;
import anon.crypto.MyDSAPrivateKey;
import anon.crypto.MyRSAPrivateKey;
import anon.crypto.tinytls.TinyTLSServerSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class TinyTLSServer
extends ServerSocket {
    private JAPCertificate m_Certificate = null;
    private IMyPrivateKey m_PrivateKey = null;
    private MyDSAPrivateKey m_DSSKey = null;
    private MyRSAPrivateKey m_RSAKey = null;
    private JAPCertificate m_DSSCertificate = null;
    private JAPCertificate m_RSACertificate = null;
    private TinyTLSServerSocket tls = null;

    public TinyTLSServer(int port) throws IOException {
        super(port);
    }

    public TinyTLSServer(int port, int backlog, InetAddress bindAddress) throws IOException {
        super(port, backlog, bindAddress);
    }

    public void setDSSParameters(JAPCertificate cert, MyDSAPrivateKey key) {
        this.m_DSSCertificate = cert;
        this.m_DSSKey = key;
    }

    public void setRSAParameters(JAPCertificate cert, MyRSAPrivateKey key) {
        this.m_RSACertificate = cert;
        this.m_RSAKey = key;
    }

    public Socket accept() throws IOException {
        return this.accept(0L);
    }

    public Socket accept(long a_forceCloseAfterMS) throws IOException {
        Socket s = super.accept();
        this.tls = new TinyTLSServerSocket(s, a_forceCloseAfterMS);
        this.tls.setDSSParameters(this.m_DSSCertificate, this.m_DSSKey);
        this.tls.setRSAParameters(this.m_RSACertificate, this.m_RSAKey);
        return this.tls;
    }
}

