/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.mixminion.message.ExitInformation;
import anon.mixminion.message.Header;
import anon.mixminion.message.MixMinionCryptoUtil;
import anon.mixminion.message.ReplyBlock;
import anon.mixminion.message.ReplyImplementation;
import anon.mixminion.message.RoutingInformation;
import anon.mixminion.mmrdescription.MMRDescription;
import anon.mixminion.mmrdescription.MMRList;
import anon.util.ByteArrayUtil;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class ReplyMessage
extends ReplyImplementation {
    private MMRList m_mmrlist;
    private int m_hops;
    private byte[][] m_message_parts;
    private Vector m_replyblocks;
    private Vector m_start_server;

    public ReplyMessage(byte[][] message_parts, int hops, Vector replyblocks, MMRList mmrlist) {
        this.m_mmrlist = mmrlist;
        this.m_hops = hops;
        this.m_message_parts = message_parts;
        this.m_replyblocks = replyblocks;
        this.m_start_server = new Vector();
    }

    public Vector buildMessage() {
        boolean isfragmented;
        Vector<byte[]> ready_to_send_Messages = new Vector<byte[]>();
        boolean bl = isfragmented = this.m_message_parts.length > 1;
        if (isfragmented) {
            System.out.println("Reply und Fragmente; Decodierung wird noch nicht moeglich sein...");
        }
        Vector paths = new Vector();
        if (!isfragmented) {
            Vector tv = this.m_mmrlist.getByRandomWithExit(this.m_hops);
            paths.addElement(tv);
        } else {
            paths = this.m_mmrlist.getByRandomWithFrag(this.m_hops, this.m_message_parts.length);
        }
        if (this.m_replyblocks.size() < this.m_message_parts.length) {
            return null;
        }
        for (int i_frag = 0; i_frag < this.m_message_parts.length; ++i_frag) {
            LogHolder.log(7, LogType.MISC, "[Message] make Header to Fragment_" + i_frag);
            byte[] headerbytes_1 = null;
            byte[] headerbytes_2 = ((ReplyBlock)this.m_replyblocks.elementAt(i_frag)).getHeaderBytes();
            Vector<byte[]> secrets = new Vector<byte[]>();
            Vector path = (Vector)paths.elementAt(i_frag);
            this.m_start_server.addElement((MMRDescription)path.elementAt(0));
            for (int i = 0; i < this.m_hops; ++i) {
                secrets.addElement(MixMinionCryptoUtil.randomArray(16));
            }
            ExitInformation exit1 = new ExitInformation();
            RoutingInformation ri1 = ((ReplyBlock)this.m_replyblocks.elementAt(i_frag)).getRouting();
            exit1.m_Type = ri1.m_Type;
            exit1.m_Content = ri1.m_Content;
            Header header1 = new Header(path, secrets, exit1);
            headerbytes_1 = header1.getAsByteArray();
            byte[] payload = this.m_message_parts[i_frag];
            byte[] packet = null;
            byte[] key = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(((ReplyBlock)this.m_replyblocks.elementAt(i_frag)).getSharedSecret(), "PAYLOAD ENCRYPT".getBytes()));
            payload = MixMinionCryptoUtil.SPRP_Decrypt(key, payload);
            headerbytes_2 = MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(MixMinionCryptoUtil.hash(payload), "HIDE HEADER".getBytes())), headerbytes_2);
            payload = MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(MixMinionCryptoUtil.hash(headerbytes_2), "HIDE PAYLOAD".getBytes())), payload);
            for (int i = secrets.size() - 1; i >= 0; --i) {
                byte[] SK1_i = (byte[])secrets.elementAt(i);
                headerbytes_2 = MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(SK1_i, "HEADER ENCRYPT".getBytes())), headerbytes_2);
                payload = MixMinionCryptoUtil.SPRP_Encrypt(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(SK1_i, "PAYLOAD ENCRYPT".getBytes())), payload);
            }
            packet = ByteArrayUtil.conc(headerbytes_1, headerbytes_2, payload);
            LogHolder.log(7, LogType.MISC, "[Message] the Messagesize = " + packet.length + " Bytes");
            ready_to_send_Messages.addElement(packet);
        }
        return ready_to_send_Messages;
    }

    public Vector getStartServers() {
        return this.m_start_server;
    }
}

