/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.proxy.AnonProxyRequest;
import anon.proxy.ProxyCallback;
import anon.proxy.ProxyCallbackBuffer;
import anon.proxy.ProxyCallbackNotProcessableException;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import logging.LogHolder;
import logging.LogType;

public class DecompressionProxyCallback
implements ProxyCallback {
    Hashtable decompressionKits = new Hashtable();
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    public static final int MAX_DECOMPRESSION_OUTPUT = 10000;

    private int readGZIPHeader(byte[] data, int offset, int length) throws DataFormatException, HeaderSplitException {
        if (length < 10) {
            throw new HeaderSplitException();
        }
        try {
            int index = offset;
            int headerMagic = this.toUnsignedShort(data[index++], data[index++]);
            if (headerMagic != 35615) {
                throw new DataFormatException("Not in GZIP format");
            }
            if (this.toUnsignedByte(data[index++]) != 8) {
                throw new DataFormatException("Unsupported compression method");
            }
            int flg = this.toUnsignedByte(data[index++]);
            index += 6;
            if ((flg & 4) == 4) {
                index = index + this.toUnsignedShort(data[index++], data[index++]);
            }
            if ((flg & 8) == 8) {
                while (this.toUnsignedShort(data[index++], data[index++]) != 0) {
                }
            }
            if ((flg & 0x10) == 16) {
                while (this.toUnsignedShort(data[index++], data[index++]) != 0) {
                }
            }
            if ((flg & 2) == 2) {
                index += 2;
            }
            if (index > offset + length) {
                throw new HeaderSplitException();
            }
            return index - offset;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new HeaderSplitException();
        }
    }

    public int toUnsignedShort(byte lower, byte upper) {
        return this.toUnsignedByte(upper) << 8 | lower;
    }

    public int toUnsignedByte(byte nByte) {
        return (nByte < 0 ? 128 : 0) + (0x7F & nByte);
    }

    public void closeRequest(AnonProxyRequest anonRequest) {
        DecompressionKit kit = (DecompressionKit)this.decompressionKits.remove(anonRequest);
        if (kit != null) {
            if (kit.getGzipInflater() != null) {
                kit.getGzipInflater().end();
            }
            if (kit.getZLibInflater() != null) {
                kit.getZLibInflater().end();
            }
        }
    }

    public int decompress(ProxyCallbackBuffer buffer, DecompressionKit decompressionKit, boolean gzipEncoding, boolean start) throws DataFormatException, ArrayIndexOutOfBoundsException {
        Inflater inflater;
        boolean readHeader = start;
        int resultLength = 0;
        int leadingDataLength = 0;
        int trailingDataLength = 0;
        int inflateLength = 0;
        int gzipHeaderOffset = 0;
        Inflater inflater2 = inflater = gzipEncoding ? decompressionKit.getGzipInflater() : decompressionKit.getZLibInflater();
        if (decompressionKit.headerBytesNotComplete()) {
            byte[] headBytes = decompressionKit.completeUnfinishedHeaderBytes();
            buffer.injectModificationData(headBytes);
            readHeader = true;
        }
        if (readHeader) {
            try {
                gzipHeaderOffset = gzipEncoding ? this.readGZIPHeader(buffer.getChunk(), buffer.getModificationStartOffset(), buffer.getModificationDataLength()) : 0;
            }
            catch (HeaderSplitException e) {
                byte[] headerBytes = buffer.extractModificationData();
                decompressionKit.addHeaderBytes(headerBytes);
                LogHolder.log(7, LogType.NET, "gzip splitted up between two chunks.");
                return 0;
            }
        }
        Inflater inflater3 = inflater = gzipEncoding ? decompressionKit.getGzipInflater() : decompressionKit.getZLibInflater();
        if (inflater.needsInput()) {
            leadingDataLength = buffer.getLeadingDataLength();
            trailingDataLength = buffer.getTrailingDataLength();
            inflateLength = decompressionKit.getResult().length - trailingDataLength - leadingDataLength;
            inflater.setInput(buffer.getChunk(), buffer.getModificationStartOffset() + gzipHeaderOffset, buffer.getModificationDataLength() - gzipHeaderOffset);
            ByteArrayOutputStream bout = null;
            resultLength = inflater.inflate(decompressionKit.getResult(), leadingDataLength, inflateLength);
            while (resultLength == inflateLength && !inflater.needsInput()) {
                if (bout == null) {
                    bout = new ByteArrayOutputStream();
                    buffer.copyLeadingData(bout);
                    bout.write(decompressionKit.getResult(), leadingDataLength, inflateLength);
                }
                inflateLength = decompressionKit.getResult().length;
                resultLength = inflater.inflate(decompressionKit.getResult());
                bout.write(decompressionKit.getResult(), 0, resultLength);
            }
            if (bout == null) {
                buffer.copyLeadingData(decompressionKit.getResult());
                buffer.copyTrailingData(decompressionKit.getResult(), leadingDataLength + resultLength);
                buffer.setChunk(decompressionKit.getResult());
                buffer.setModificationStartOffset(leadingDataLength + resultLength);
                buffer.setModificationEndOffset(buffer.getModificationStartOffset());
                buffer.setPayloadLength(buffer.getModificationStartOffset() + trailingDataLength);
            } else {
                buffer.copyTrailingData(bout);
                byte[] newChunk = bout.toByteArray();
                buffer.setChunk(newChunk);
                buffer.setModificationStartOffset(newChunk.length - trailingDataLength);
                buffer.setModificationEndOffset(buffer.getModificationStartOffset());
            }
            if (inflater.finished()) {
                LogHolder.log(6, LogType.NET, "finish connection after decompressing.");
                inflater.reset();
                return 2;
            }
        }
        return 2;
    }

    public synchronized int handleDownstreamChunk(AnonProxyRequest anonRequest, ProxyCallbackBuffer buffer) throws ProxyCallbackNotProcessableException {
        String[] contentEncodingValues;
        if (buffer.getModificationStartOffset() < buffer.getPayloadLength() && (contentEncodingValues = anonRequest.getContentEncodings()) != null) {
            Vector<String> compressionSequence = new Vector<String>();
            StringTokenizer valueTokenizer = null;
            for (int i = 0; i < contentEncodingValues.length; ++i) {
                valueTokenizer = new StringTokenizer(contentEncodingValues[i], "");
                String currentEncodingToken = null;
                while (valueTokenizer.hasMoreTokens()) {
                    currentEncodingToken = valueTokenizer.nextToken();
                    if (currentEncodingToken.trim().equals("gzip") || currentEncodingToken.trim().equals("deflate")) {
                        compressionSequence.addElement(currentEncodingToken);
                        continue;
                    }
                    LogHolder.log(4, LogType.NET, "The Content-Encoding " + currentEncodingToken + " is not supported.");
                }
            }
            if (compressionSequence.size() > 0) {
                String currentEncoding = null;
                DecompressionKit decompressionKit = null;
                boolean start = false;
                boolean gzipEncoding = true;
                try {
                    for (int i = 0; i < compressionSequence.size(); ++i) {
                        currentEncoding = (String)compressionSequence.elementAt(i);
                        gzipEncoding = currentEncoding.equals("gzip");
                        decompressionKit = (DecompressionKit)this.decompressionKits.get(anonRequest);
                        if (decompressionKit == null) {
                            decompressionKit = new DecompressionKit();
                            decompressionKit.setNewInflater(gzipEncoding);
                            decompressionKit.setResult(new byte[10000]);
                            this.decompressionKits.put(anonRequest, decompressionKit);
                            start = true;
                        }
                        if (this.decompress(buffer, decompressionKit, gzipEncoding, start) != 0) continue;
                        return 0;
                    }
                }
                catch (DataFormatException e) {
                    Inflater inflater;
                    if (decompressionKit != null && (inflater = decompressionKit.getInflater(gzipEncoding)) != null) {
                        inflater.reset();
                    }
                    LogHolder.log(4, LogType.NET, "compressed data has invalid format.", e);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Inflater inflater;
                    if (decompressionKit != null && (inflater = decompressionKit.getInflater(gzipEncoding)) != null) {
                        inflater.reset();
                    }
                    LogHolder.log(3, LogType.NET, "indexing error occured while decompressing data. Maybe the result buffer is too small?", e);
                }
            }
        }
        return 2;
    }

    public int handleUpstreamChunk(AnonProxyRequest anonRequest, ProxyCallbackBuffer buffer) throws ProxyCallbackNotProcessableException {
        return 2;
    }

    private class HeaderSplitException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private HeaderSplitException() {
        }
    }

    public static class DecompressionKit {
        private Inflater gzipInflater = null;
        private Inflater zLibInflater = null;
        private ByteArrayOutputStream unfinishedGzipHeader;
        private byte[] result = null;

        public byte[] getResult() {
            return this.result;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }

        public Inflater getGzipInflater() {
            return this.gzipInflater;
        }

        public void setGzipInflater(Inflater gzipInflater) {
            this.gzipInflater = gzipInflater;
        }

        public Inflater getZLibInflater() {
            return this.zLibInflater;
        }

        public void setZLibInflater(Inflater libInflater) {
            this.zLibInflater = libInflater;
        }

        public Inflater getInflater(boolean gzipInflation) {
            return gzipInflation ? this.gzipInflater : this.zLibInflater;
        }

        public void setNewInflater(boolean gzipInflater) {
            if (gzipInflater) {
                this.setGzipInflater(new Inflater(true));
            } else {
                this.setZLibInflater(new Inflater());
            }
        }

        private void addHeaderBytes(byte[] headerBytes) {
            this.addHeaderBytes(headerBytes, 0, headerBytes.length);
        }

        private void addHeaderBytes(byte[] headerBytes, int offset, int length) {
            if (this.unfinishedGzipHeader == null) {
                this.unfinishedGzipHeader = new ByteArrayOutputStream();
            }
            this.unfinishedGzipHeader.write(headerBytes, offset, length);
        }

        private byte[] completeUnfinishedHeaderBytes() {
            byte[] completeHeaderBytes = this.unfinishedGzipHeader.toByteArray();
            this.unfinishedGzipHeader = null;
            return completeHeaderBytes;
        }

        public boolean headerBytesNotComplete() {
            return this.unfinishedGzipHeader != null;
        }
    }
}

