/*
 * Decompiled with CFR 0.152.
 */
package anon.terms.template;

import anon.terms.TCComponent;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Paragraph
extends TCComponent
implements IXMLEncodable {
    public static String XML_ELEMENT_CONTAINER_NAME = "Section";
    public static String XML_ELEMENT_NAME = "Paragraph";
    private Vector elementNodes = null;
    private boolean hasElementNodes = false;

    public Paragraph() {
        this.content = new Vector();
        this.elementNodes = new Vector(3);
        this.hasElementNodes = false;
    }

    public Paragraph(double id) {
        this();
        this.setId(id);
    }

    public Paragraph(Node root) throws XMLParseException {
        this();
        Element rootElement = null;
        if (root.getNodeType() == 9) {
            rootElement = ((Document)root).getDocumentElement();
        } else if (root.getNodeType() == 1) {
            rootElement = (Element)root;
        } else {
            throw new XMLParseException("Invalid node type.");
        }
        if (!rootElement.getTagName().equals(XML_ELEMENT_NAME)) {
            throw new XMLParseException("Invalid Tag name: " + rootElement.getTagName());
        }
        this.id = XMLUtil.parseAttribute((Node)rootElement, "id", -1.0);
        if (this.id < 0.0) {
            throw new XMLParseException("Attribute id missing: " + XMLUtil.toString(root));
        }
        this.setContent(rootElement.getChildNodes());
    }

    public void replaceElementNodes(NodeList nodes) {
        Element former = null;
        Element substitute = null;
        NodeList elementDeepList = null;
        Element deepElement = null;
        Object deepElementParent = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            substitute = (Element)nodes.item(i);
            for (int j = 0; j < this.elementNodes.size(); ++j) {
                former = (Element)this.elementNodes.elementAt(j);
                if (former.getTagName().equals(substitute.getTagName())) {
                    this.elementNodes.removeElementAt(j);
                    this.elementNodes.insertElementAt(substitute, j);
                    int contentIndex = this.contentNodes().indexOf(former);
                    this.contentNodes().removeElementAt(contentIndex);
                    this.contentNodes().insertElementAt(substitute, contentIndex);
                    continue;
                }
                elementDeepList = former.getElementsByTagName(substitute.getTagName());
                for (int k = 0; k < elementDeepList.getLength(); ++k) {
                    deepElement = (Element)elementDeepList.item(k);
                    try {
                        deepElement.getParentNode().replaceChild(XMLUtil.importNode(deepElement.getParentNode().getOwnerDocument(), substitute, true), deepElement);
                        continue;
                    }
                    catch (XMLParseException a_e) {
                        LogHolder.log(0, LogType.MISC, a_e);
                    }
                }
            }
        }
    }

    public boolean hasElementNodes() {
        return this.hasElementNodes;
    }

    public void setContent(Object o) {
        NodeList nl = null;
        if (o != null) {
            if (!(o instanceof NodeList)) {
                if (o instanceof Node[]) {
                    nl = Paragraph.toNodeList((Node[])o);
                } else {
                    StringBuffer contentBuffer = new StringBuffer();
                    contentBuffer.append("<?xml version=\"1.0\"?><temp>");
                    contentBuffer.append(o);
                    contentBuffer.append("</temp>");
                    try {
                        Document tempDoc = XMLUtil.readXMLDocument(new StringReader(contentBuffer.toString()));
                        nl = tempDoc.getDocumentElement() != null ? tempDoc.getDocumentElement().getChildNodes() : null;
                    }
                    catch (IOException e) {
                        LogHolder.log(7, LogType.MISC, "Cannot set content, reason: " + e.getMessage());
                        return;
                    }
                    catch (XMLParseException e) {
                        LogHolder.log(7, LogType.MISC, "Cannot set content, reason: " + e.getMessage());
                        return;
                    }
                }
            } else {
                nl = (NodeList)o;
            }
        }
        this.elementNodes.removeAllElements();
        this.contentNodes().removeAllElements();
        this.hasElementNodes = false;
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i).cloneNode(true);
                if (n.getNodeType() == 1) {
                    this.elementNodes.addElement(n);
                    this.hasElementNodes = true;
                }
                this.contentNodes().addElement(n);
            }
        }
    }

    public Object getContent() {
        final Node[] contentNodesArray = new Node[this.contentNodes().size()];
        for (int i = 0; i < contentNodesArray.length; ++i) {
            contentNodesArray[i] = (Node)this.contentNodes().elementAt(i);
        }
        return new NodeList(){

            public int getLength() {
                return contentNodesArray.length;
            }

            public Node item(int index) {
                return contentNodesArray[index];
            }
        };
    }

    public void setContentBold() {
        NodeList contentNodeList = (NodeList)this.getContent();
        Document tempDoc = XMLUtil.createDocument();
        Node boldElement = null;
        this.elementNodes.removeAllElements();
        this.contentNodes().removeAllElements();
        for (int i = 0; i < contentNodeList.getLength(); ++i) {
            if (contentNodeList.item(i).getNodeType() == 1 && ((Element)contentNodeList.item(i)).getTagName().toLowerCase().equals("b")) {
                boldElement = contentNodeList.item(i);
            } else if (contentNodeList.item(i).getNodeType() != 3 || contentNodeList.item(i).getNodeValue() != null && !contentNodeList.item(i).getNodeValue().trim().equals("")) {
                boldElement = tempDoc.createElement("b");
                try {
                    boldElement.appendChild(XMLUtil.importNode(tempDoc, contentNodeList.item(i), true));
                }
                catch (XMLParseException a_e) {
                    LogHolder.log(1, LogType.MISC, a_e);
                }
            } else {
                boldElement = null;
            }
            if (boldElement == null) continue;
            this.contentNodes().addElement(boldElement);
            this.elementNodes.addElement(boldElement);
        }
        this.hasElementNodes = this.elementNodes.size() > 0;
    }

    private Vector contentNodes() {
        return (Vector)this.content;
    }

    public boolean hasContent() {
        return super.hasContent() && this.contentNodes().size() > 0;
    }

    public Element toXmlElement(Document ownerDoc) {
        return this.toXmlElement(ownerDoc, false);
    }

    public Element toXmlElement(Document ownerDoc, boolean outputEmpty) {
        if (this.id < 0.0 || this.contentNodes().size() == 0 && !outputEmpty) {
            return null;
        }
        Element rootElement = ownerDoc.createElement(XML_ELEMENT_NAME);
        rootElement.setAttribute("id", "" + this.id);
        for (int i = 0; i < this.contentNodes().size(); ++i) {
            try {
                rootElement.appendChild(XMLUtil.importNode(ownerDoc, (Node)this.contentNodes().elementAt(i), true));
                continue;
            }
            catch (XMLParseException a_e) {
                LogHolder.log(0, LogType.MISC, a_e);
            }
        }
        return rootElement;
    }

    public Object clone() {
        Paragraph paragraph = new Paragraph();
        paragraph.setId(this.id);
        paragraph.setContent(this.getContent());
        return paragraph;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        String currentNodeContent = null;
        StringTokenizer contentTokenizer = null;
        for (int i = 0; i < this.contentNodes().size(); ++i) {
            currentNodeContent = XMLUtil.toString((Node)this.contentNodes().elementAt(i));
            contentTokenizer = new StringTokenizer(currentNodeContent, "\n");
            while (contentTokenizer.hasMoreTokens()) {
                buff.append(contentTokenizer.nextToken().trim());
                buff.append("\n");
            }
        }
        return buff.toString().trim();
    }

    public static NodeList toNodeList(Node[] nodeArray) {
        final Node[] fNodeArray = nodeArray;
        return new NodeList(){

            public int getLength() {
                return fNodeArray.length;
            }

            public Node item(int index) {
                return fNodeArray[index];
            }
        };
    }
}

