/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.infoservice.JavaVersionDBEntry;
import anon.platform.AbstractOS;
import anon.platform.WindowsOS;
import anon.util.ClassUtil;
import anon.util.IReturnRunnable;
import anon.util.JAPMessages;
import anon.util.LanguageMapper;
import gui.GUIUtils;
import gui.JAPDll;
import gui.TitledGridBagPanel;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import gui.dialog.SimpleWizardContentPane;
import gui.dialog.WorkerContentPane;
import gui.help.JAPExternalHelpViewer;
import gui.help.JAPHelp;
import jap.AbstractJAPConfModule;
import jap.JAPConf;
import jap.JAPConstants;
import jap.JAPController;
import jap.JAPModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import logging.LogHolder;
import logging.LogType;

final class JAPConfUI
extends AbstractJAPConfModule {
    private static final String MSG_ON_CLOSING_JAP = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_onClosingJAP";
    private static final String MSG_WARNING_ON_CLOSING_JAP = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_warningOnClosingJAP";
    private static final String MSG_FONT_SIZE = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_fontSize";
    private static final String MSG_WARNING_IMPORT_LNF = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_warningImportLNF";
    private static final String MSG_INCOMPATIBLE_JAVA = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_incompatibleJava";
    private static final String MSG_REMOVE = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_remove";
    private static final String MSG_IMPORT = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_import";
    private static final String MSG_COULD_NOT_REMOVE = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_couldNotRemove";
    private static final String MSG_TITLE_IMPORT = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_titleImport";
    private static final String MSG_PROGRESS_IMPORTING = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_progressImport";
    private static final String MSG_IMPORT_SUCCESSFUL = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_importSuccessful";
    private static final String MSG_NO_LNF_FOUND = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_noLNFFound";
    private static final String MSG_LOOK_AND_FEEL_CHANGED = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_lnfChanged";
    private static final String MSG_RESTART_TO_UNLOAD = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_restartToUnload";
    private static final String MSG_DIALOG_FORMAT = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_lblDialogFormat";
    private static final String MSG_DIALOG_FORMAT_TEST = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_dialogFormatTest";
    private static final String MSG_DIALOG_FORMAT_TEST_2 = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_dialogFormatTest2";
    private static final String MSG_DIALOG_FORMAT_TEST_BTN = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_dialogFormatTestBtn";
    private static final String MSG_DIALOG_FORMAT_GOLDEN_RATIO = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_dialogFormatGoldenRatio";
    private static final String MSG_TEST_BROWSER_PATH = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_testBrowserPath";
    private static final String MSG_BROWSER_SHOULD_OPEN = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_browserShouldOpen";
    private static final String MSG_BROWSER_DOES_NOT_OPEN = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_browserDoesNotStart";
    private static final String MSG_BROWSER_TEST_PATH = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_browserTestPath";
    private static final String MSG_BROWSER_NEW_PATH = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_browserNewPath";
    private static final String MSG_BROWSER_TEST_BUTTON = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_browserTestBtn";
    private static final String MSG_BROWSER_TEST_EXPLAIN = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_browserTestExplain";
    private static final String MSG_HELP_PATH = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_helpPath";
    private static final String MSG_HELP_PATH_CHOOSE = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_helpPathChange";
    private static final String MSG_BROWSER_PATH = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_browserPath";
    private static final String MSG_BROWSER_PATH_CHOOSE = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_browserPathChange";
    private static final String MSG_NO_NATIVE_LIBRARY = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_noNativeLibrary";
    private static final String MSG_NO_NATIVE_WINDOWS_LIBRARY = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_noNativeWindowsLibrary";
    private static final String MSG_WINDOW_POSITION = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_windowPosition";
    private static final String MSG_WINDOW_MAIN = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_windowMain";
    private static final String MSG_WINDOW_CONFIG = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_windowConfig";
    private static final String MSG_WINDOW_ICON = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_windowIcon";
    private static final String MSG_WINDOW_HELP = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_windowHelp";
    private static final String MSG_WINDOW_SIZE = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_windowSize";
    private static final String MSG_MINI_ON_TOP = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_miniOnTop";
    private static final String MSG_MINI_ON_TOP_TT = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_miniOnTopTT";
    private static final String MSG_ENABLE_CLOSE_BUTTON = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + ".enableCloseButton";
    private static final String MSG_CHOOSE_OTHER_DIR = (class$jap$JAPConfUI == null ? (class$jap$JAPConfUI = JAPConfUI.class$("jap.JAPConfUI")) : class$jap$JAPConfUI).getName() + "_chooseOtherDir";
    private TitledBorder m_borderLookAndFeel;
    private TitledBorder m_borderView;
    private JComboBox m_comboLanguage;
    private JComboBox m_comboUI;
    private JComboBox m_comboDialogFormat;
    private JCheckBox m_cbSaveWindowLocationMain;
    private JCheckBox m_cbSaveWindowLocationIcon;
    private JCheckBox m_cbSaveWindowLocationConfig;
    private JCheckBox m_cbSaveWindowLocationHelp;
    private JCheckBox m_cbSaveWindowSizeConfig;
    private JCheckBox m_cbSaveWindowSizeHelp;
    private JCheckBox m_cbAfterStart;
    private JCheckBox m_cbShowSplash;
    private JCheckBox m_cbStartPortableFirefox;
    private JRadioButton m_rbViewSimplified;
    private JRadioButton m_rbViewNormal;
    private JRadioButton m_rbViewMini;
    private JRadioButton m_rbViewSystray;
    private JCheckBox m_cbWarnOnClose;
    private JCheckBox m_cbMiniOnTop;
    private JCheckBox m_cbIgnoreDLLUpdate;
    private JCheckBox m_cbEnableCloseButton;
    private JSlider m_slidFontSize;
    private JButton m_btnAddUI;
    private JButton m_btnDeleteUI;
    private File m_currentDirectory;
    private JTextField m_helpPathField;
    private JButton m_helpPathButton;
    private JTextField m_portableBrowserPathField;
    private JButton m_portableBrowserPathButton;
    private Observer m_modelObserver = new Observer(){

        public void update(Observable a_notifier, Object a_message) {
            if (a_message == JAPModel.CHANGED_HELP_PATH) {
                JAPConfUI.this.updateHelpPath();
                if (JAPModel.getInstance().isHelpPathChangeable()) {
                    JAPConfUI.this.m_helpPathButton.setEnabled(true);
                } else {
                    JAPConfUI.this.m_helpPathButton.setEnabled(false);
                }
            } else if (a_message == JAPModel.CHANGED_DLL_UPDATE) {
                JAPConfUI.this.m_cbIgnoreDLLUpdate.setSelected(!JAPModel.getInstance().isDLLWarningActive());
                JAPConfUI.this.m_cbIgnoreDLLUpdate.setEnabled(JAPModel.getInstance().getDllUpdatePath() != null);
            }
        }
    };
    private boolean m_bClickedBrowserPath = false;
    static /* synthetic */ Class class$jap$JAPConfUI;

    public JAPConfUI() {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initObservers() {
        if (super.initObservers()) {
            Object object = this.LOCK_OBSERVABLE;
            synchronized (object) {
                JAPModel.getInstance().addObserver(this.m_modelObserver);
                return true;
            }
        }
        return false;
    }

    public void chooseBrowserPath() {
        if (this.m_bClickedBrowserPath) {
            return;
        }
        this.m_bClickedBrowserPath = true;
        this.chooseBrowserPath(null);
        this.m_bClickedBrowserPath = false;
    }

    private void chooseBrowserPath(String a_defaultFilePath) {
        File browserFile = null;
        JFileChooser chooser = a_defaultFilePath != null && new File(a_defaultFilePath).exists() ? new JFileChooser(a_defaultFilePath) : (JAPModel.getInstance().getPortableBrowserpath() != null ? new JFileChooser(JAPModel.getInstance().getPortableBrowserpath()) : (AbstractOS.getInstance().getDefaultBrowserPath() != null ? new JFileChooser(AbstractOS.getInstance().getDefaultBrowserPath()) : new JFileChooser(System.getProperty("user.dir"))));
        chooser.setFileSelectionMode(0);
        if (GUIUtils.showMonitoredFileChooser(chooser, this.getRootPanel(), "__FILE_CHOOSER_OPEN") == 0) {
            browserFile = chooser.getSelectedFile();
        }
        if (browserFile != null) {
            final String filePath = AbstractOS.toRelativePath(browserFile.getPath());
            JAPDialog browserTestDialog = new JAPDialog(this.getRootPanel(), JAPMessages.getString(MSG_TEST_BROWSER_PATH));
            DialogContentPane pane = new DialogContentPane(browserTestDialog, JAPMessages.getString(MSG_BROWSER_TEST_EXPLAIN), new DialogContentPaneOptions(1)){
                private boolean m_bValid = false;

                public DialogContentPane.CheckError checkNo() {
                    if (AbstractOS.getInstance().openBrowser(AbstractOS.createBrowserCommand(filePath))) {
                        this.printStatusMessage(JAPMessages.getString(MSG_BROWSER_SHOULD_OPEN));
                        this.m_bValid = true;
                        return null;
                    }
                    return new DialogContentPane.CheckError(JAPMessages.getString(MSG_BROWSER_DOES_NOT_OPEN));
                }

                public DialogContentPane.CheckError checkYesOK() {
                    if (!this.m_bValid) {
                        return new DialogContentPane.CheckError(JAPMessages.getString(MSG_BROWSER_TEST_PATH));
                    }
                    return null;
                }

                public String getButtonYesOKText() {
                    return JAPMessages.getString(DialogContentPane.MSG_OK);
                }

                public String getButtonNoText() {
                    return JAPMessages.getString(MSG_BROWSER_TEST_BUTTON);
                }

                public String getButtonCancelText() {
                    return JAPMessages.getString(MSG_BROWSER_NEW_PATH);
                }
            };
            pane.setDefaultButtonOperation(40960);
            pane.pack();
            browserTestDialog.setResizable(false);
            browserTestDialog.setVisible(true);
            browserTestDialog.dispose();
            if (pane.getButtonValue() == 0) {
                this.m_portableBrowserPathField.setText(filePath);
                this.m_portableBrowserPathField.repaint();
            } else if (pane.getButtonValue() == 2) {
                this.chooseBrowserPath(browserFile.getPath());
            }
        }
    }

    public void recreateRootPanel() {
        JPanel panelRoot = this.getRootPanel();
        panelRoot.removeAll();
        boolean bSimpleView = JAPModel.getDefaultView() == 2;
        GridBagLayout gbl1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        panelRoot.setLayout(gbl1);
        c1.insets = new Insets(0, 0, 0, 0);
        c1.gridx = 0;
        c1.gridy = 0;
        c1.anchor = 18;
        c1.fill = 1;
        c1.weightx = 1.0;
        c1.gridwidth = 2;
        panelRoot.add((Component)this.createLookAndFeelPanel(), c1);
        c1.insets = new Insets(0, 0, 0, 0);
        c1.gridwidth = 1;
        ++c1.gridy;
        c1.gridx = 0;
        panelRoot.add((Component)this.createViewPanel(), c1);
        c1.insets = new Insets(0, 0, 0, 0);
        c1.gridx = 1;
        panelRoot.add((Component)this.createAfterStartupPanel(), c1);
        ++c1.gridy;
        c1.fill = 1;
        JPanel tempPanel = this.createWindowSizePanel();
        if (!bSimpleView) {
            panelRoot.add((Component)tempPanel, c1);
        }
        ++c1.gridy;
        tempPanel = this.createAfterShutdownPanel();
        if (!bSimpleView) {
            panelRoot.add((Component)tempPanel, c1);
        }
        c1.gridx = 0;
        --c1.gridy;
        c1.gridheight = 2;
        c1.fill = 1;
        tempPanel = this.createWindowPanel();
        if (!bSimpleView) {
            panelRoot.add((Component)tempPanel, c1);
        }
        c1.gridx = 0;
        c1.gridy += 2;
        c1.fill = 1;
        c1.gridwidth = 2;
        c1.gridheight = 1;
        tempPanel = this.createHelpPathPanel();
        if (JAPModel.getInstance().isHelpPathChangeable()) {
            panelRoot.add((Component)tempPanel, c1);
        }
        ++c1.gridy;
        tempPanel = this.createBrowserPathPanel();
        if (JAPController.getInstance().isPortableMode()) {
            panelRoot.add((Component)tempPanel, c1);
        }
        ++c1.gridy;
        c1.weighty = 1.0;
        panelRoot.add((Component)new JPanel(), c1);
    }

    public void afterPack() {
        this.m_comboUI.setVisible(true);
    }

    public void beforePack() {
        this.m_comboUI.setVisible(false);
    }

    private JPanel createLookAndFeelPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.m_borderLookAndFeel = new TitledBorder(JAPMessages.getString("settingsLookAndFeelBorder"));
        JPanel p = new JPanel(gbl);
        p.setBorder(this.m_borderLookAndFeel);
        JLabel l = new JLabel(JAPMessages.getString("settingsLookAndFeel"));
        c.insets = new Insets(10, 10, 10, 10);
        c.gridy = 1;
        c.anchor = 18;
        p.add((Component)l, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.m_comboUI = new JComboBox();
        p.add((Component)this.m_comboUI, c);
        this.m_comboUI.setVisible(false);
        this.m_btnDeleteUI = new JButton(JAPMessages.getString(MSG_REMOVE));
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        p.add((Component)this.m_btnDeleteUI, c);
        this.m_btnDeleteUI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent a_event) {
                try {
                    JComboBox jComboBox = JAPConfUI.this.m_comboUI;
                    synchronized (jComboBox) {
                        int i;
                        UIManager.LookAndFeelInfo[] oldLnFs = UIManager.getInstalledLookAndFeels();
                        Vector<UIManager.LookAndFeelInfo> tempLnFs = new Vector<UIManager.LookAndFeelInfo>(oldLnFs.length - 1);
                        File lnfFile = ClassUtil.getClassDirectory(oldLnFs[JAPConfUI.this.m_comboUI.getSelectedIndex()].getClassName());
                        for (i = 0; i < oldLnFs.length; ++i) {
                            File tempLnfFile = ClassUtil.getClassDirectory(oldLnFs[i].getClassName());
                            if (tempLnfFile != null && lnfFile.equals(tempLnfFile)) continue;
                            tempLnFs.addElement(oldLnFs[i]);
                        }
                        UIManager.LookAndFeelInfo[] alteredLnFs = new UIManager.LookAndFeelInfo[tempLnFs.size()];
                        for (i = 0; i < alteredLnFs.length; ++i) {
                            alteredLnFs[i] = (UIManager.LookAndFeelInfo)tempLnFs.elementAt(i);
                        }
                        UIManager.setInstalledLookAndFeels(alteredLnFs);
                        JAPModel.getInstance().removeLookAndFeelFile(lnfFile);
                        JAPConfUI.this.updateUICombo();
                    }
                    JAPDialog.showMessageDialog(JAPConfUI.this.getRootPanel(), JAPMessages.getString(MSG_RESTART_TO_UNLOAD));
                }
                catch (Exception a_e) {
                    JAPDialog.showErrorDialog((Component)JAPConfUI.this.getRootPanel(), JAPMessages.getString(MSG_COULD_NOT_REMOVE), (Throwable)a_e);
                }
            }
        });
        this.m_btnAddUI = new JButton(JAPMessages.getString(MSG_IMPORT));
        ++c.gridx;
        p.add((Component)this.m_btnAddUI, c);
        this.m_btnAddUI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                final JFileChooser fileChooser = new JFileChooser(JAPConfUI.this.m_currentDirectory);
                final JAPDialog dialog = new JAPDialog(JAPConfUI.this.getRootPanel(), JAPMessages.getString(MSG_TITLE_IMPORT));
                LookAndFeel currentLaf = UIManager.getLookAndFeel();
                FileFilter filter = new FileFilter(){

                    public boolean accept(File a_file) {
                        return a_file.isDirectory() || a_file.getName().endsWith(".jar");
                    }

                    public String getDescription() {
                        return "*.jar";
                    }
                };
                fileChooser.setFileFilter(filter);
                final SimpleWizardContentPane pane = new SimpleWizardContentPane(dialog, "<font color='red'>" + JAPMessages.getString(MSG_WARNING_IMPORT_LNF) + "</font>", new DialogContentPane.Layout(JAPMessages.getString(JAPDialog.MSG_TITLE_WARNING), 2), null){
                    boolean m_bCanceled = false;

                    public DialogContentPane.CheckError checkYesOK() {
                        this.m_bCanceled = false;
                        DialogContentPane.CheckError errors = super.checkYesOK();
                        fileChooser.setFileSelectionMode(0);
                        if (GUIUtils.showMonitoredFileChooser(fileChooser, dialog.getContentPane(), "__FILE_CHOOSER_OPEN") != 0) {
                            this.m_bCanceled = true;
                        }
                        return errors;
                    }

                    public Object getValue() {
                        return new Boolean(this.m_bCanceled);
                    }
                };
                final IReturnRunnable doIt = new IReturnRunnable(){
                    Object m_value;

                    public Object getValue() {
                        return this.m_value;
                    }

                    public void run() {
                        if (fileChooser.getSelectedFile() != null) {
                            JAPConfUI.this.m_currentDirectory = fileChooser.getCurrentDirectory();
                            try {
                                Vector files = GUIUtils.registerLookAndFeelClasses(fileChooser.getSelectedFile());
                                if (files.size() > 0) {
                                    for (int i = 0; i < files.size(); ++i) {
                                        LogHolder.log(5, LogType.GUI, "Added new L&F class file: " + files.elementAt(i));
                                        JAPModel.getInstance().addLookAndFeelFile((File)files.elementAt(i));
                                    }
                                    JAPConfUI.this.updateUICombo();
                                    this.m_value = JAPMessages.getString(MSG_IMPORT_SUCCESSFUL);
                                } else {
                                    this.m_value = new Exception(JAPMessages.getString(MSG_NO_LNF_FOUND));
                                }
                            }
                            catch (IllegalAccessException a_e) {
                                this.m_value = new Exception(JAPMessages.getString(MSG_INCOMPATIBLE_JAVA));
                            }
                            fileChooser.setSelectedFile(null);
                        }
                    }
                };
                WorkerContentPane importPane = new WorkerContentPane(dialog, JAPMessages.getString(MSG_PROGRESS_IMPORTING) + "...", (DialogContentPane)pane, (Runnable)doIt){

                    public boolean isSkippedAsNextContentPane() {
                        return (Boolean)pane.getValue();
                    }
                };
                SimpleWizardContentPane goodResultPane = new SimpleWizardContentPane(dialog, "OK", new DialogContentPane.Layout(JAPMessages.getString(JAPDialog.MSG_TITLE_INFO), 1), new DialogContentPaneOptions(importPane)){

                    public DialogContentPane.CheckError checkUpdate() {
                        this.setText((String)doIt.getValue());
                        return null;
                    }

                    public boolean isSkippedAsNextContentPane() {
                        return (Boolean)pane.getValue() != false || doIt.getValue() instanceof Exception;
                    }

                    public boolean isSkippedAsPreviousContentPane() {
                        return true;
                    }

                    public boolean hideButtonCancel() {
                        return true;
                    }
                };
                SimpleWizardContentPane errorPane = new SimpleWizardContentPane(dialog, "ERROR", new DialogContentPane.Layout(JAPMessages.getString(JAPDialog.MSG_TITLE_ERROR), 0), new DialogContentPaneOptions(goodResultPane)){

                    public boolean isSkippedAsPreviousContentPane() {
                        return true;
                    }

                    public DialogContentPane.CheckError checkUpdate() {
                        this.setText(((Exception)doIt.getValue()).getMessage());
                        return null;
                    }

                    public boolean isSkippedAsNextContentPane() {
                        return (Boolean)pane.getValue() != false || !(doIt.getValue() instanceof Exception);
                    }

                    public boolean hideButtonCancel() {
                        return true;
                    }
                };
                JLabel dummyLabel = new JLabel("AAAAAAAAAAAAAAAAAAAAAAAA");
                importPane.getContentPane().add(dummyLabel);
                pane.pack();
                dummyLabel.setVisible(false);
                dialog.setVisible(true);
                if (currentLaf != UIManager.getLookAndFeel()) {
                    JAPDialog.showMessageDialog(JAPConfUI.this.getRootPanel(), JAPMessages.getString(MSG_LOOK_AND_FEEL_CHANGED));
                }
            }
        });
        this.m_comboUI.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void itemStateChanged(ItemEvent a_event) {
                JComboBox jComboBox = JAPConfUI.this.m_comboUI;
                synchronized (jComboBox) {
                    if (JAPConfUI.this.m_comboUI.getSelectedIndex() >= 0) {
                        String selectedLaFClass = UIManager.getInstalledLookAndFeels()[JAPConfUI.this.m_comboUI.getSelectedIndex()].getClassName();
                        String currentLaFClass = JAPModel.getInstance().getLookAndFeel();
                        String activeLaFClass = UIManager.getLookAndFeel().getClass().getName();
                        File currentLaFFile = null;
                        File activeLaFFile = null;
                        File selectedLaFFile = null;
                        activeLaFFile = ClassUtil.getClassDirectory(activeLaFClass);
                        currentLaFFile = ClassUtil.getClassDirectory(currentLaFClass);
                        selectedLaFFile = ClassUtil.getClassDirectory(selectedLaFClass);
                        if (selectedLaFFile != null && currentLaFFile != null && currentLaFFile.equals(selectedLaFFile) || selectedLaFFile != null && activeLaFFile != null && activeLaFFile.equals(selectedLaFFile) || currentLaFClass.equals(selectedLaFClass) || activeLaFClass.equals(selectedLaFClass) || JAPModel.getInstance().isSystemLookAndFeel(selectedLaFClass)) {
                            JAPConfUI.this.m_btnDeleteUI.setEnabled(false);
                        } else {
                            JAPConfUI.this.m_btnDeleteUI.setEnabled(true);
                        }
                    }
                }
            }
        });
        l = new JLabel(JAPMessages.getString("settingsLanguage"));
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        p.add((Component)l, c);
        this.m_comboLanguage = new JComboBox();
        String[] languages = JAPConstants.getSupportedLanguages();
        for (int i = 0; i < languages.length; ++i) {
            this.m_comboLanguage.addItem(new LanguageMapper(languages[i], new Locale(languages[i], "")));
        }
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        p.add((Component)this.m_comboLanguage, c);
        l = new JLabel(JAPMessages.getString(JAPMessages.getString(MSG_DIALOG_FORMAT)));
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 0;
        c.weightx = 0.0;
        p.add((Component)l, c);
        l.setVisible(JAPModel.getInstance().isDialogFormatShown());
        c.gridx = 1;
        c.fill = 2;
        this.m_comboDialogFormat = new JComboBox();
        this.m_comboDialogFormat.addItem(new DialogFormat(JAPMessages.getString(MSG_DIALOG_FORMAT_GOLDEN_RATIO), 0));
        this.m_comboDialogFormat.addItem(new DialogFormat("4:3", 1));
        this.m_comboDialogFormat.addItem(new DialogFormat("16:9", 2));
        p.add((Component)this.m_comboDialogFormat, c);
        JButton btnTestFormat = new JButton(JAPMessages.getString(MSG_DIALOG_FORMAT_TEST_BTN));
        btnTestFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                int currentFormat = JAPDialog.getOptimizedFormat();
                JAPDialog.setOptimizedFormat(((DialogFormat)JAPConfUI.this.m_comboDialogFormat.getSelectedItem()).getFormat());
                JAPDialog.showMessageDialog(JAPConfUI.this.getRootPanel(), JAPMessages.getString(MSG_DIALOG_FORMAT_TEST));
                JAPDialog.setOptimizedFormat(currentFormat);
            }
        });
        c.gridx = 2;
        c.weightx = 0.0;
        p.add((Component)btnTestFormat, c);
        this.m_comboDialogFormat.setVisible(JAPModel.getInstance().isDialogFormatShown());
        btnTestFormat.setVisible(JAPModel.getInstance().isDialogFormatShown());
        btnTestFormat = new JButton(JAPMessages.getString(MSG_DIALOG_FORMAT_TEST_BTN));
        btnTestFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                int currentFormat = JAPDialog.getOptimizedFormat();
                JAPDialog.setOptimizedFormat(((DialogFormat)JAPConfUI.this.m_comboDialogFormat.getSelectedItem()).getFormat());
                JAPDialog.showMessageDialog(JAPConfUI.this.getRootPanel(), JAPMessages.getString(MSG_DIALOG_FORMAT_TEST_2));
                JAPDialog.setOptimizedFormat(currentFormat);
            }
        });
        c.gridx = 3;
        c.weightx = 0.0;
        p.add((Component)btnTestFormat, c);
        btnTestFormat.setVisible(JAPModel.getInstance().isDialogFormatShown());
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        c.gridwidth = 1;
        p.add((Component)new JLabel(JAPMessages.getString(MSG_FONT_SIZE)), c);
        this.m_slidFontSize = new JSlider(0, 0, 3, JAPModel.getInstance().getFontSize());
        this.m_slidFontSize.setPaintTicks(false);
        this.m_slidFontSize.setPaintLabels(true);
        this.m_slidFontSize.setMajorTickSpacing(1);
        this.m_slidFontSize.setMinorTickSpacing(1);
        this.m_slidFontSize.setSnapToTicks(true);
        this.m_slidFontSize.setPaintTrack(true);
        Hashtable<Integer, JLabel> map = new Hashtable<Integer, JLabel>(4);
        for (int i = 0; i <= 3; ++i) {
            map.put(new Integer(i), new JLabel("1" + i + "0%"));
        }
        this.m_slidFontSize.setLabelTable(map);
        c.gridwidth = 3;
        ++c.gridx;
        p.add((Component)this.m_slidFontSize, c);
        return p;
    }

    private JPanel createWindowSizePanel() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(JAPMessages.getString(MSG_WINDOW_SIZE)));
        this.m_cbSaveWindowSizeConfig = new JCheckBox(JAPMessages.getString(MSG_WINDOW_CONFIG));
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 10);
        p.add((Component)this.m_cbSaveWindowSizeConfig, c);
        this.m_cbSaveWindowSizeHelp = new JCheckBox(JAPMessages.getString(MSG_WINDOW_HELP));
        ++c.gridy;
        return p;
    }

    private JPanel createWindowPanel() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(JAPMessages.getString(MSG_WINDOW_POSITION)));
        this.m_cbSaveWindowLocationMain = new JCheckBox(JAPMessages.getString(MSG_WINDOW_MAIN));
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 10);
        p.add((Component)this.m_cbSaveWindowLocationMain, c);
        this.m_cbSaveWindowLocationConfig = new JCheckBox(JAPMessages.getString(MSG_WINDOW_CONFIG));
        ++c.gridy;
        p.add((Component)this.m_cbSaveWindowLocationConfig, c);
        this.m_cbSaveWindowLocationIcon = new JCheckBox(JAPMessages.getString(MSG_WINDOW_ICON));
        ++c.gridy;
        p.add((Component)this.m_cbSaveWindowLocationIcon, c);
        this.m_cbSaveWindowLocationHelp = new JCheckBox(JAPMessages.getString(MSG_WINDOW_HELP));
        ++c.gridy;
        return p;
    }

    private JPanel createViewPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.m_borderView = new TitledBorder(JAPMessages.getString("ngSettingsViewBorder"));
        JPanel p = new JPanel(gbl);
        p.setBorder(this.m_borderView);
        this.m_rbViewNormal = new JRadioButton(JAPMessages.getString("ngSettingsViewNormal"));
        this.m_rbViewSimplified = new JRadioButton(JAPMessages.getString("ngSettingsViewSimplified"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rbViewNormal);
        bg.add(this.m_rbViewSimplified);
        c.insets = new Insets(0, 10, 10, 10);
        c.weightx = 1.0;
        c.anchor = 18;
        p.add((Component)this.m_rbViewNormal, c);
        c.gridy = 1;
        p.add((Component)this.m_rbViewSimplified, c);
        ++c.gridy;
        this.m_cbMiniOnTop = new JCheckBox(JAPMessages.getString(MSG_MINI_ON_TOP));
        if (JAPDll.getDllVersion() == null && JavaVersionDBEntry.CURRENT_JAVA_VERSION.compareTo("1.5") < 0) {
            this.m_cbMiniOnTop.setEnabled(false);
            this.m_cbMiniOnTop.setToolTipText(JAPMessages.getString(MSG_MINI_ON_TOP_TT));
        }
        p.add((Component)this.m_cbMiniOnTop, c);
        ++c.gridy;
        this.m_cbEnableCloseButton = new JCheckBox(JAPMessages.getString(MSG_ENABLE_CLOSE_BUTTON));
        if (JAPDll.getDllVersion() == null) {
            this.m_cbEnableCloseButton.setEnabled(false);
        }
        p.add((Component)this.m_cbEnableCloseButton, c);
        ++c.gridy;
        this.m_cbIgnoreDLLUpdate = new JCheckBox(JAPMessages.getString(JAPDll.MSG_IGNORE_UPDATE));
        if (JAPDll.getDllVersion() == null || JAPModel.getInstance().getDllUpdatePath() == null) {
            this.m_cbIgnoreDLLUpdate.setEnabled(false);
        }
        p.add((Component)this.m_cbIgnoreDLLUpdate, c);
        return p;
    }

    private JPanel createAfterShutdownPanel() {
        TitledGridBagPanel panel = new TitledGridBagPanel(JAPMessages.getString(MSG_ON_CLOSING_JAP), new Insets(0, 10, 0, 10));
        this.m_cbWarnOnClose = new JCheckBox(JAPMessages.getString(MSG_WARNING_ON_CLOSING_JAP));
        this.m_cbWarnOnClose.setEnabled(!JAPController.getInstance().isPortableMode());
        panel.addRow(this.m_cbWarnOnClose, null);
        return panel;
    }

    private JPanel createAfterStartupPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel p = new JPanel(gbl);
        p.setBorder(new TitledBorder(JAPMessages.getString("ngSettingsStartBorder")));
        this.m_cbAfterStart = new JCheckBox(JAPMessages.getString("ngViewAfterStart"));
        this.m_cbAfterStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean b = JAPConfUI.this.m_cbAfterStart.isSelected();
                JAPConfUI.this.updateThirdPanel(b);
            }
        });
        c.insets = new Insets(0, 10, 0, 10);
        c.anchor = 18;
        c.weightx = 1.0;
        p.add((Component)this.m_cbAfterStart, c);
        this.m_rbViewMini = new JRadioButton(JAPMessages.getString("ngViewMini"));
        this.m_rbViewSystray = new JRadioButton(JAPMessages.getString("ngViewSystray"));
        if (JAPDll.getDllVersion() == null) {
            if (AbstractOS.getInstance() instanceof WindowsOS) {
                this.m_rbViewSystray.setToolTipText(JAPMessages.getString(MSG_NO_NATIVE_WINDOWS_LIBRARY));
            } else {
                this.m_rbViewSystray.setToolTipText(JAPMessages.getString(MSG_NO_NATIVE_LIBRARY));
            }
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rbViewMini);
        bg.add(this.m_rbViewSystray);
        c.gridy = 1;
        c.insets = new Insets(5, 30, 0, 10);
        p.add((Component)this.m_rbViewMini, c);
        c.gridy = 2;
        p.add((Component)this.m_rbViewSystray, c);
        this.m_cbShowSplash = new JCheckBox(JAPMessages.getString("ngViewShowSplash"));
        this.m_cbShowSplash.setEnabled(!JAPModel.getInstance().getShowSplashDisabled());
        c.gridy = 3;
        c.insets = new Insets(0, 10, 0, 10);
        p.add((Component)this.m_cbShowSplash, c);
        this.m_cbStartPortableFirefox = new JCheckBox(JAPMessages.getString("ngViewStartPortableFirefox"));
        this.m_cbStartPortableFirefox.setEnabled(JAPController.getInstance().isPortableMode());
        c.gridy = 4;
        p.add((Component)this.m_cbStartPortableFirefox, c);
        return p;
    }

    private JPanel createBrowserPathPanel() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(JAPMessages.getString(MSG_BROWSER_PATH)));
        c.weightx = 1.0;
        this.m_portableBrowserPathField = new JTextField(10);
        this.m_portableBrowserPathField.setEditable(false);
        this.m_portableBrowserPathButton = new JButton(JAPMessages.getString(MSG_BROWSER_PATH_CHOOSE));
        if (JAPModel.getInstance().getPortableBrowserpath() != null) {
            this.m_portableBrowserPathField.setText(JAPModel.getInstance().getPortableBrowserpath());
        } else if (AbstractOS.getInstance().getDefaultBrowserPath() != null) {
            this.m_portableBrowserPathField.setText(AbstractOS.getInstance().getDefaultBrowserPath());
        } else {
            this.m_portableBrowserPathField.setText("");
        }
        ActionListener buttonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent aev) {
                JAPConfUI.this.chooseBrowserPath();
            }
        };
        this.m_portableBrowserPathButton.addActionListener(buttonActionListener);
        if (!JAPController.getInstance().isPortableMode()) {
            this.m_portableBrowserPathButton.setEnabled(false);
        }
        c.anchor = 18;
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 10, 0, 10);
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this.m_portableBrowserPathField, c);
        ++c.gridx;
        c.weightx = 0.0;
        p.add((Component)this.m_portableBrowserPathButton, c);
        return p;
    }

    private JPanel createHelpPathPanel() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(JAPMessages.getString(MSG_HELP_PATH)));
        c.weightx = 1.0;
        this.m_helpPathField = new JTextField(10);
        this.m_helpPathField.setEditable(false);
        this.m_helpPathButton = new JButton(JAPMessages.getString(MSG_HELP_PATH_CHOOSE));
        if (JAPModel.getInstance().isHelpPathDefined()) {
            this.m_helpPathField.setText(JAPModel.getInstance().getHelpPath());
        } else {
            this.m_helpPathField.setText("");
        }
        ActionListener helpInstallButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent aev) {
                JAPModel model = JAPModel.getInstance();
                File hpFile = null;
                JFileChooser chooser = new JFileChooser(model.getHelpPath());
                chooser.setFileSelectionMode(1);
                if (GUIUtils.showMonitoredFileChooser(chooser, JAPConfUI.this.getRootPanel(), "__FILE_CHOOSER_OPEN") == 0) {
                    hpFile = chooser.getSelectedFile();
                }
                if (hpFile != null) {
                    String hpFileValidation = model.helpPathValidityCheck(hpFile);
                    if (hpFileValidation.equals("HELP_IS_VALID") || hpFileValidation.equals("helpJonDoExists")) {
                        JAPConfUI.this.m_helpPathField.setText(hpFile.getPath());
                        JAPConfUI.this.m_helpPathField.repaint();
                    } else {
                        JAPDialog.showErrorDialog((JAPDialog)JAPConf.getInstance(), JAPMessages.getString(hpFileValidation) + " " + JAPMessages.getString(MSG_CHOOSE_OTHER_DIR));
                    }
                }
            }
        };
        this.m_helpPathButton.addActionListener(helpInstallButtonActionListener);
        if (!JAPModel.getInstance().isHelpPathChangeable()) {
            this.m_helpPathButton.setEnabled(false);
        }
        c.anchor = 18;
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(0, 10, 0, 10);
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)this.m_helpPathField, c);
        ++c.gridx;
        c.weightx = 0.0;
        p.add((Component)this.m_helpPathButton, c);
        return p;
    }

    private void submitHelpPathChange() {
        if (this.m_helpPathField == null) {
            return;
        }
        final JAPModel model = JAPModel.getInstance();
        String strCheck = JAPModel.getInstance().helpPathValidityCheck(this.m_helpPathField.getText());
        if (!(!strCheck.equals("HELP_IS_VALID") && !strCheck.equals("helpJonDoExists") || model.getHelpPath() != null && model.getHelpPath().equals(this.m_helpPathField.getText()))) {
            JAPDialog dialog = new JAPDialog(this.getRootPanel(), JAPMessages.getString(JAPExternalHelpViewer.MSG_HELP_INSTALL));
            Runnable run = new Runnable(){

                public void run() {
                    model.setHelpPath(new File(JAPConfUI.this.m_helpPathField.getText()));
                }
            };
            WorkerContentPane workerPane = new WorkerContentPane(dialog, JAPMessages.getString("helpInstallProgress"), run, model.getHelpFileStorageObservable());
            workerPane.updateDialog();
            dialog.setResizable(false);
            dialog.setVisible(true);
            if (workerPane.getProgressStatus() != 0) {
                this.resetHelpPath();
                JAPDialog.showErrorDialog((JAPDialog)JAPConf.getInstance(), JAPMessages.getString(JAPExternalHelpViewer.MSG_HELP_INSTALL_FAILED));
            }
        }
    }

    private void resetHelpPath() {
        if (this.m_helpPathField != null) {
            this.m_helpPathField.setText("");
        }
    }

    private void updateHelpPath() {
        if (this.m_helpPathField != null) {
            if (JAPModel.getInstance().isHelpPathDefined() && JAPModel.getInstance().isHelpPathChangeable()) {
                this.m_helpPathField.setText(JAPModel.getInstance().getHelpPath());
            } else {
                this.m_helpPathField.setText("");
            }
        }
    }

    public String getTabTitle() {
        return JAPMessages.getString("ngUIPanelTitle");
    }

    protected void onCancelPressed() {
        this.updateValues(false);
    }

    protected boolean onOkPressed() {
        JAPModel model = JAPModel.getInstance();
        int oldFontSize = model.getFontSize();
        if (model.setFontSize(this.m_slidFontSize.getValue())) {
            if (!model.isConfigWindowSizeSaved()) {
                this.beforePack();
                JAPConf.getInstance().doPack();
                this.afterPack();
            }
        } else {
            oldFontSize = -1;
        }
        model.setSaveMainWindowPosition(this.m_cbSaveWindowLocationMain.isSelected());
        model.setSaveConfigWindowPosition(this.m_cbSaveWindowLocationConfig.isSelected());
        model.setSaveIconifiedWindowPosition(this.m_cbSaveWindowLocationIcon.isSelected());
        model.setSaveHelpWindowPosition(this.m_cbSaveWindowLocationHelp.isSelected());
        model.setSaveHelpWindowSize(this.m_cbSaveWindowSizeHelp.isSelected());
        model.setSaveConfigWindowSize(this.m_cbSaveWindowSizeConfig.isSelected());
        if (JAPHelp.getHelpDialog() != null) {
            JAPHelp.getHelpDialog().resetAutomaticLocation(this.m_cbSaveWindowLocationHelp.isSelected());
        }
        if (JAPModel.getInstance().isConfigWindowSizeSaved()) {
            JAPModel.getInstance().setConfigSize(JAPConf.getInstance().getSize());
        }
        JAPController.getInstance().setMinimizeOnStartup(this.m_rbViewMini.isSelected() && this.m_cbAfterStart.isSelected());
        JAPController.getInstance().setMoveToSystrayOnStartup(this.m_rbViewSystray.isSelected() && this.m_cbAfterStart.isSelected());
        JAPModel.getInstance().setShowSplashScreen(this.m_cbShowSplash.isSelected());
        JAPModel.getInstance().setStartPortableFirefox(this.m_cbStartPortableFirefox.isSelected());
        JAPModel.getInstance().setNeverRemindGoodbye(!this.m_cbWarnOnClose.isSelected());
        JAPModel.getInstance().setMiniViewOnTop(this.m_cbMiniOnTop.isSelected());
        JAPModel.getInstance().setShowCloseButton(this.m_cbEnableCloseButton.isSelected());
        JAPModel.getInstance().setDllWarning(!this.m_cbIgnoreDLLUpdate.isSelected());
        Locale newLocale = this.m_comboLanguage.getSelectedIndex() >= 0 ? ((LanguageMapper)this.m_comboLanguage.getSelectedItem()).getLocale() : JAPMessages.getLocale();
        if (!JAPMessages.getLocale().equals(newLocale)) {
            final Locale localeRestart = newLocale;
            JAPConf.getInstance().addNeedRestart(new JAPConf.AbstractRestartNeedingConfigChange(){

                public String getName() {
                    return JAPMessages.getString("settingsLanguage");
                }

                public void doChange() {
                    JAPMessages.setLocale(localeRestart);
                }
            });
        }
        int newDefaultView = 1;
        if (this.m_rbViewSimplified.isSelected()) {
            newDefaultView = 2;
        }
        if (JAPModel.getDefaultView() != newDefaultView) {
            final int defaultViewRestart = newDefaultView;
            JAPConf.getInstance().addNeedRestart(new JAPConf.AbstractRestartNeedingConfigChange(){

                public String getName() {
                    return JAPMessages.getString("ngSettingsViewBorder");
                }

                public void doChange() {
                    JAPController.getInstance().setDefaultView(defaultViewRestart);
                }
            });
        }
        if (this.m_portableBrowserPathField.getText() != null && this.m_portableBrowserPathField.getText().trim().length() > 0 && !AbstractOS.toAbsolutePath(this.m_portableBrowserPathField.getText()).equals(AbstractOS.toAbsolutePath(JAPModel.getInstance().getPortableBrowserpath()))) {
            JAPConf.getInstance().addNeedRestart(new JAPConf.AbstractRestartNeedingConfigChange(){

                public String getName() {
                    return JAPMessages.getString(MSG_BROWSER_PATH);
                }

                public void doChange() {
                    JAPModel.getInstance().setPortableBrowserpath(JAPConfUI.this.m_portableBrowserPathField.getText());
                }
            });
        }
        JAPDialog.setOptimizedFormat(((DialogFormat)this.m_comboDialogFormat.getSelectedItem()).getFormat());
        String newLaF = this.m_comboUI.getSelectedIndex() >= 0 ? UIManager.getInstalledLookAndFeels()[this.m_comboUI.getSelectedIndex()].getClassName() : UIManager.getLookAndFeel().getClass().getName();
        if (UIManager.getLookAndFeel().getClass().getName().equals(newLaF)) {
            newLaF = null;
        }
        if (newLaF != null || oldFontSize >= 0) {
            final String lafRestart = newLaF;
            final int OLD_FONT_SIZE = oldFontSize;
            JAPConf.getInstance().addNeedRestart(new JAPConf.AbstractRestartNeedingConfigChange(){

                public String getName() {
                    return JAPMessages.getString("settingsLookAndFeel");
                }

                public void doChange() {
                    if (lafRestart != null) {
                        JAPModel.getInstance().setLookAndFeel(lafRestart);
                    }
                }

                public void doCancel() {
                    if (OLD_FONT_SIZE >= 0) {
                        JAPConfUI.this.m_slidFontSize.setValue(OLD_FONT_SIZE);
                        JAPModel.getInstance().setFontSize(OLD_FONT_SIZE);
                        JAPConfUI.this.beforePack();
                        JAPConf.getInstance().doPack();
                        JAPConfUI.this.afterPack();
                    }
                }
            });
        }
        this.submitHelpPathChange();
        return true;
    }

    private void setLanguageComboIndex(Locale a_locale) {
        int i;
        LanguageMapper langMapper = new LanguageMapper(a_locale.getLanguage());
        for (i = 0; i < this.m_comboLanguage.getItemCount(); ++i) {
            if (!this.m_comboLanguage.getItemAt(i).equals(langMapper)) continue;
            this.m_comboLanguage.setSelectedIndex(i);
            break;
        }
        if (i == this.m_comboLanguage.getItemCount()) {
            this.m_comboLanguage.setSelectedIndex(0);
        }
    }

    protected void onUpdateValues() {
        this.updateUICombo();
        if (JAPModel.getInstance().getPortableBrowserpath() != null) {
            this.m_portableBrowserPathField.setText(JAPModel.getInstance().getPortableBrowserpath());
        } else {
            this.m_portableBrowserPathField.setText(AbstractOS.getInstance().getDefaultBrowserPath());
        }
        this.m_slidFontSize.setValue(JAPModel.getInstance().getFontSize());
        this.setLanguageComboIndex(JAPMessages.getLocale());
        this.m_cbSaveWindowLocationMain.setSelected(JAPModel.isMainWindowLocationSaved());
        this.m_cbSaveWindowLocationConfig.setSelected(JAPModel.getInstance().isConfigWindowLocationSaved());
        this.m_cbSaveWindowLocationIcon.setSelected(JAPModel.getInstance().isIconifiedWindowLocationSaved());
        this.m_cbSaveWindowLocationHelp.setSelected(JAPModel.getInstance().isHelpWindowLocationSaved());
        this.m_cbSaveWindowSizeHelp.setSelected(JAPModel.getInstance().isHelpWindowSizeSaved());
        this.m_cbSaveWindowSizeConfig.setSelected(JAPModel.getInstance().isConfigWindowSizeSaved());
        this.m_rbViewNormal.setSelected(JAPModel.getDefaultView() == 1);
        this.m_rbViewSimplified.setSelected(JAPModel.getDefaultView() == 2);
        this.m_rbViewSystray.setSelected(JAPModel.getMoveToSystrayOnStartup());
        this.m_rbViewMini.setSelected(JAPModel.getMinimizeOnStartup());
        this.m_cbMiniOnTop.setSelected(JAPModel.getInstance().isMiniViewOnTop());
        this.m_cbEnableCloseButton.setSelected(JAPModel.getInstance().isCloseButtonShown());
        this.m_cbIgnoreDLLUpdate.setSelected(!JAPModel.getInstance().isDLLWarningActive());
        this.m_cbWarnOnClose.setSelected(!JAPModel.getInstance().isNeverRemindGoodbye());
        this.m_cbShowSplash.setSelected(JAPModel.getInstance().getShowSplashScreen());
        this.m_cbStartPortableFirefox.setSelected(JAPModel.getInstance().getStartPortableFirefox());
        boolean b = JAPModel.getMoveToSystrayOnStartup() || JAPModel.getMinimizeOnStartup();
        for (int i = 0; i < this.m_comboDialogFormat.getItemCount(); ++i) {
            if (((DialogFormat)this.m_comboDialogFormat.getItemAt(i)).getFormat() != JAPDialog.getOptimizedFormat()) continue;
            this.m_comboDialogFormat.setSelectedIndex(i);
            break;
        }
        this.updateThirdPanel(b);
        this.updateHelpPath();
    }

    public void onResetToDefaultsPressed() {
        this.setLanguageComboIndex(JAPMessages.getSystemLocale());
        UIManager.LookAndFeelInfo[] lookandfeels = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookandfeels.length; ++i) {
            if (!lookandfeels[i].getClassName().equals(UIManager.getCrossPlatformLookAndFeelClassName())) continue;
            this.m_comboUI.setSelectedIndex(i);
            break;
        }
        this.m_portableBrowserPathField.setText(AbstractOS.getInstance().getDefaultBrowserPath());
        this.m_cbSaveWindowLocationConfig.setSelected(false);
        this.m_cbSaveWindowLocationIcon.setSelected(true);
        this.m_cbSaveWindowLocationMain.setSelected(true);
        this.m_cbSaveWindowLocationHelp.setSelected(false);
        this.m_cbSaveWindowSizeHelp.setSelected(false);
        this.m_cbSaveWindowSizeConfig.setSelected(false);
        this.m_rbViewNormal.setSelected(false);
        this.m_rbViewSimplified.setSelected(true);
        this.m_rbViewSystray.setSelected(false);
        this.m_rbViewMini.setSelected(false);
        this.m_cbMiniOnTop.setSelected(true);
        this.m_cbEnableCloseButton.setSelected(false);
        this.m_cbIgnoreDLLUpdate.setSelected(false);
        this.m_cbShowSplash.setSelected(true);
        this.m_cbStartPortableFirefox.setSelected(true);
        this.m_cbWarnOnClose.setSelected(true);
        this.updateThirdPanel(false);
        this.resetHelpPath();
    }

    private void updateThirdPanel(boolean bAfterStart) {
        this.m_cbAfterStart.setSelected(bAfterStart);
        this.m_rbViewMini.setEnabled(bAfterStart);
        this.m_rbViewSystray.setEnabled(bAfterStart && JAPDll.getDllVersion() != null);
        if (bAfterStart && !this.m_rbViewSystray.isSelected() && !this.m_rbViewMini.isSelected()) {
            this.m_rbViewMini.setSelected(true);
        }
    }

    public String getHelpContext() {
        return "appearance";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUICombo() {
        JComboBox jComboBox = this.m_comboUI;
        synchronized (jComboBox) {
            int lfidx;
            int i;
            UIManager.LookAndFeelInfo[] lf = UIManager.getInstalledLookAndFeels();
            Vector<UIManager.LookAndFeelInfo> vecLFs = new Vector<UIManager.LookAndFeelInfo>(lf.length);
            Vector<String> vecLFNames = new Vector<String>(lf.length);
            String currentLf = UIManager.getLookAndFeel().getClass().getName();
            for (i = 0; i < lf.length; ++i) {
                if (vecLFNames.contains(lf[i].getClassName())) continue;
                vecLFNames.addElement(lf[i].getClassName());
                vecLFs.addElement(lf[i]);
            }
            lf = new UIManager.LookAndFeelInfo[vecLFs.size()];
            for (i = 0; i < lf.length; ++i) {
                lf[i] = (UIManager.LookAndFeelInfo)vecLFs.elementAt(i);
            }
            UIManager.setInstalledLookAndFeels(lf);
            this.m_comboUI.removeAllItems();
            for (lfidx = 0; lfidx < lf.length; ++lfidx) {
                this.m_comboUI.addItem(lf[lfidx].getName());
            }
            for (lfidx = 0; lfidx < lf.length; ++lfidx) {
                if (!lf[lfidx].getClassName().equals(currentLf)) continue;
                this.m_comboUI.setSelectedIndex(lfidx);
                break;
            }
            if (lfidx >= lf.length) {
                this.m_comboUI.addItem("(unknown)");
                this.m_comboUI.setSelectedIndex(lfidx);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DialogFormat {
        String m_description;
        int m_format;

        public DialogFormat(String a_description, int a_format) {
            this.m_description = a_description;
            this.m_format = a_format;
        }

        public String toString() {
            return this.m_description;
        }

        public int getFormat() {
            return this.m_format;
        }
    }
}

