/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.client.AbstractAutoSwitchedMixCascadeContainer;
import anon.client.TrustModel;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.PopupMenu;
import jap.CascadePopupMenu;
import jap.JAPConfAnon;
import jap.JAPController;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class JAPMixCascadeComboBox
extends JComboBox {
    static final String ITEM_AVAILABLE_SERVERS = "ITEM_AVAILABLE_SERVERS";
    static final String ITEM_NO_SERVERS_AVAILABLE = "ITEM_NO_SERVERS_AVAILABLE";
    private MixCascade m_currentCascade;
    private JPopupMenu m_comboPopup;
    private JAPMixCascadeComboBoxListCellRender m_renderer;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;

    public JAPMixCascadeComboBox() {
        this.setModel(new JAPMixCascadeComboBoxModel());
        this.m_renderer = new JAPMixCascadeComboBoxListCellRender();
        this.setRenderer(this.m_renderer);
        this.setEditable(false);
    }

    public void addItem(Object o) {
    }

    public MixCascade getMixCascade() {
        return this.m_currentCascade;
    }

    public void showStaticPopup() {
        if (this.m_comboPopup != null) {
            this.m_comboPopup.setVisible(true);
        } else {
            super.showPopup();
        }
    }

    public boolean isPopupVisible() {
        if (this.m_comboPopup != null) {
            return this.m_comboPopup.isVisible();
        }
        return super.isPopupVisible();
    }

    public void closeCascadePopupMenu() {
        this.m_renderer.closeCascadePopupMenu();
        if (this.m_comboPopup != null) {
            this.m_comboPopup.setVisible(false);
        } else {
            super.hidePopup();
        }
    }

    public synchronized void setMixCascade(MixCascade cascade) {
        this.m_currentCascade = cascade;
        this.removeAllItems();
    }

    public void validate() {
        if (!JAPController.getInstance().getCurrentMixCascade().equals(this.m_currentCascade)) {
            this.removeAllItems();
        }
        super.validate();
    }

    public synchronized void removeAllItems() {
        MixCascade service;
        this.setModel(new JAPMixCascadeComboBoxModel());
        Vector trustModels = TrustModel.getTrustModels();
        if (this.m_currentCascade != null) {
            super.addItem(this.m_currentCascade);
        }
        TrustModel model = TrustModel.getCurrentTrustModel();
        Hashtable hashServices = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = JAPMixCascadeComboBox.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryHash();
        Enumeration enumServices = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = JAPMixCascadeComboBox.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntrySnapshotAsEnumeration();
        if (model.hasFreeCascades()) {
            while (enumServices.hasMoreElements()) {
                service = (MixCascade)enumServices.nextElement();
                if (!hashServices.containsKey(service.getId()) || service.isPayment() || !model.isTrusted(service) || this.m_currentCascade != null && this.m_currentCascade.getId().equals(service.getId())) continue;
                hashServices.remove(service.getId());
                super.addItem(service);
            }
        }
        enumServices = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = JAPMixCascadeComboBox.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntrySnapshotAsEnumeration();
        while (enumServices.hasMoreElements()) {
            service = (MixCascade)enumServices.nextElement();
            if (!hashServices.containsKey(service.getId()) || !model.isTrusted(service) || this.m_currentCascade != null && this.m_currentCascade.getId().equals(service.getId())) continue;
            hashServices.remove(service.getId());
            super.addItem(service);
        }
    }

    public void setNoDataAvailable() {
        super.insertItemAt(ITEM_NO_SERVERS_AVAILABLE, 0);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d.width > 50) {
            d.width = 50;
        }
        return d;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class JAPMixCascadeComboBoxListCellRender
    implements ListCellRenderer {
        private final Color m_newCascadeColor = new Color(255, 255, 170);
        private JLabel m_componentNoServer;
        private JLabel m_componentAvailableServer;
        private JLabel m_componentUserServer;
        private JLabel m_componentAvailableCascade;
        private JLabel[] m_flags;
        private JLabel[] m_names;
        private JPanel m_componentPanel;
        private GridBagConstraints m_componentConstraints;
        private Object SYNC_POPUP = new Object();
        private JLabel m_lblCascadePopupMenu;
        private JLabel m_lblMenuArrow;
        private JPanel m_cascadePopupMenu;
        private CascadePopupMenu m_currentCascadePopup;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JAPMixCascadeComboBoxListCellRender() {
            this.m_componentPanel = new JPanel(new GridBagLayout());
            this.m_componentPanel.setOpaque(true);
            this.m_componentConstraints = new GridBagConstraints();
            this.m_componentConstraints.anchor = 17;
            this.m_componentConstraints.gridy = 0;
            this.m_componentConstraints.insets = new Insets(0, 0, 0, 0);
            this.m_componentConstraints.fill = 2;
            this.m_componentNoServer = new JLabel(JAPMessages.getString("ngMixComboNoServers"));
            this.m_componentNoServer.setIcon(GUIUtils.loadImageIcon("error.gif", true));
            this.m_componentNoServer.setBorder(new EmptyBorder(0, 3, 0, 3));
            this.m_componentNoServer.setForeground(Color.red);
            this.m_componentAvailableServer = new JLabel(JAPMessages.getString("ngMixComboAvailableServers"));
            this.m_componentAvailableServer.setOpaque(true);
            this.m_componentAvailableServer.setHorizontalAlignment(2);
            this.m_componentAvailableServer.setBorder(new EmptyBorder(1, 3, 1, 3));
            this.m_componentUserServer = new JLabel(JAPMessages.getString("ngMixComboUserServers"));
            this.m_componentUserServer.setBorder(new EmptyBorder(1, 3, 1, 3));
            this.m_componentUserServer.setHorizontalAlignment(2);
            this.m_componentUserServer.setOpaque(true);
            this.m_componentAvailableCascade = new JLabel();
            this.m_componentAvailableCascade.setHorizontalAlignment(2);
            this.m_componentAvailableCascade.setOpaque(true);
            this.m_componentAvailableCascade.setBorder(new EmptyBorder(1, 3, 1, 3));
            this.m_flags = new JLabel[3];
            this.m_names = new JLabel[3];
            for (int i = 0; i < this.m_flags.length; ++i) {
                this.m_flags[i] = new JLabel();
                this.m_flags[i].setHorizontalAlignment(2);
                this.m_flags[i].setOpaque(false);
                this.m_flags[i].setBorder(new EmptyBorder(0, 1, 0, 2));
                this.m_names[i] = new JLabel();
                this.m_names[i].setHorizontalAlignment(2);
                this.m_names[i].setOpaque(false);
            }
            this.m_lblCascadePopupMenu = new JLabel();
            this.m_lblCascadePopupMenu.setOpaque(true);
            this.m_cascadePopupMenu = new JPanel(new GridBagLayout());
            this.m_cascadePopupMenu.setBorder(new EmptyBorder(1, 3, 1, 1));
            GridBagConstraints contraints = new GridBagConstraints();
            contraints.anchor = 17;
            contraints.gridx = 0;
            contraints.gridy = 0;
            this.m_cascadePopupMenu.add((Component)this.m_lblCascadePopupMenu, contraints);
            ++contraints.gridx;
            contraints.anchor = 13;
            contraints.weightx = 1.0;
            this.m_lblMenuArrow = new JLabel(GUIUtils.loadImageIcon("arrow46.gif", true));
            this.m_lblMenuArrow.setOpaque(true);
            this.m_cascadePopupMenu.add((Component)this.m_lblMenuArrow, contraints);
            this.m_cascadePopupMenu.setOpaque(true);
            Object object = this.SYNC_POPUP;
            synchronized (object) {
                this.m_currentCascadePopup = new CascadePopupMenu(true);
                this.m_currentCascadePopup.registerExitHandler(new PopupMenu.ExitHandler(){

                    public void exited() {
                        JAPMixCascadeComboBoxListCellRender.this.m_currentCascadePopup.setVisible(false);
                        if (JAPMixCascadeComboBox.this.m_comboPopup == null || !JAPMixCascadeComboBox.this.m_comboPopup.isVisible()) {
                            JAPMixCascadeComboBox.this.showPopup();
                        }
                    }
                });
            }
            GUIUtils.addAWTEventListener(new GUIUtils.AWTEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventDispatched(AWTEvent a_event) {
                    if (a_event instanceof MouseEvent) {
                        MouseEvent event = (MouseEvent)a_event;
                        if (a_event.getSource() instanceof Component) {
                            Component component = (Component)a_event.getSource();
                            Point positionOnScreen = null;
                            try {
                                positionOnScreen = component.getLocationOnScreen();
                                positionOnScreen.x += event.getX();
                                positionOnScreen.y += event.getY();
                            }
                            catch (IllegalComponentStateException a_e) {
                                // empty catch block
                            }
                            Object object = JAPMixCascadeComboBoxListCellRender.this.SYNC_POPUP;
                            synchronized (object) {
                                if (JAPMixCascadeComboBoxListCellRender.this.m_currentCascadePopup.getRelativePosition(positionOnScreen) == null && GUIUtils.getRelativePosition(positionOnScreen, JAPMixCascadeComboBox.this.m_comboPopup) == null && JAPMixCascadeComboBoxListCellRender.this.m_currentCascadePopup.isVisible() && (JAPMixCascadeComboBox.this.m_comboPopup == null || !JAPMixCascadeComboBox.this.m_comboPopup.isVisible())) {
                                    JAPMixCascadeComboBox.this.showStaticPopup();
                                }
                            }
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeCascadePopupMenu() {
            Object object = this.SYNC_POPUP;
            synchronized (object) {
                if (this.m_currentCascadePopup != null) {
                    this.m_currentCascadePopup.setVisible(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color foreground;
            Color background;
            Object component;
            if (JAPMixCascadeComboBox.this.m_comboPopup == null) {
                GUIUtils.getMousePosition();
                component = this.m_cascadePopupMenu.getParent();
                while (component != null) {
                    if (!((component = ((Component)component).getParent()) instanceof JPopupMenu)) continue;
                    JAPMixCascadeComboBox.this.m_comboPopup = (JPopupMenu)component;
                    break;
                }
            }
            if (value == null) {
                return new JLabel();
            }
            component = this.SYNC_POPUP;
            synchronized (component) {
                if (isSelected && this.m_currentCascadePopup.isVisible() && this.m_currentCascadePopup.getTrustModel() != null && !this.m_currentCascadePopup.getTrustModel().equals(value) && this.m_currentCascadePopup.getMousePosition() == null) {
                    this.m_currentCascadePopup.setVisible(false);
                }
            }
            if (value instanceof TrustModel) {
                if (isSelected) {
                    component = this.SYNC_POPUP;
                    synchronized (component) {
                        if (!this.m_currentCascadePopup.isVisible()) {
                            Point location = list.getLocationOnScreen();
                            int x = location.x + list.getWidth();
                            int y = location.y + list.indexToLocation((int)index).y;
                            if (this.m_currentCascadePopup.update((TrustModel)value)) {
                                Point popupLocation = this.m_currentCascadePopup.calculateLocationOnScreen(list, new Point(x, y -= this.m_currentCascadePopup.getHeaderHeight()));
                                if (popupLocation.x < x) {
                                    x = location.x - this.m_currentCascadePopup.getWidth();
                                    popupLocation = this.m_currentCascadePopup.calculateLocationOnScreen(list, new Point(x, y));
                                }
                                this.m_currentCascadePopup.setLocation(popupLocation);
                                this.m_currentCascadePopup.setVisible(true);
                            }
                        }
                    }
                    this.m_cascadePopupMenu.setBackground(list.getSelectionBackground());
                    this.m_cascadePopupMenu.setForeground(list.getSelectionForeground());
                } else {
                    this.m_cascadePopupMenu.setBackground(list.getBackground());
                    this.m_cascadePopupMenu.setForeground(list.getForeground());
                }
                this.m_lblMenuArrow.setBackground(this.m_cascadePopupMenu.getBackground());
                this.m_lblMenuArrow.setForeground(this.m_cascadePopupMenu.getForeground());
                this.m_lblCascadePopupMenu.setBackground(this.m_cascadePopupMenu.getBackground());
                this.m_lblCascadePopupMenu.setForeground(this.m_cascadePopupMenu.getForeground());
                String strActive = "";
                if (((TrustModel)value).equals(TrustModel.getCurrentTrustModel())) {
                    this.m_lblCascadePopupMenu.setFont(new Font(this.m_lblCascadePopupMenu.getFont().getName(), 1, this.m_lblCascadePopupMenu.getFont().getSize()));
                } else {
                    this.m_lblCascadePopupMenu.setFont(new Font(this.m_lblCascadePopupMenu.getFont().getName(), 0, this.m_lblCascadePopupMenu.getFont().getSize()));
                }
                this.m_lblCascadePopupMenu.setText(JAPMessages.getString(JAPConfAnon.MSG_FILTER) + ": " + ((TrustModel)value).getName() + strActive);
                return this.m_cascadePopupMenu;
            }
            if (value.equals(JAPMixCascadeComboBox.ITEM_NO_SERVERS_AVAILABLE)) {
                return this.m_componentNoServer;
            }
            if (value.equals(JAPMixCascadeComboBox.ITEM_AVAILABLE_SERVERS)) {
                return this.m_componentAvailableServer;
            }
            MixCascade cascade = (MixCascade)value;
            ImageIcon icon = cascade.isUserDefined() ? (TrustModel.getCurrentTrustModel().isTrusted(cascade) ? GUIUtils.loadImageIcon("servermanuell.gif", true) : GUIUtils.loadImageIcon("cdisabled.gif", true)) : (cascade.isPayment() ? (TrustModel.getCurrentTrustModel().isTrusted(cascade) ? GUIUtils.loadImageIcon("serverwithpayment.gif", true) : GUIUtils.loadImageIcon("cdisabled.gif", true)) : (TrustModel.getCurrentTrustModel().isTrusted(cascade) ? GUIUtils.loadImageIcon("serverfrominternet.gif", true) : GUIUtils.loadImageIcon("cdisabled.gif", true)));
            if (cascade.isSocks5Supported()) {
                icon = GUIUtils.combine(icon, GUIUtils.loadImageIcon("socks_icon.gif", true));
            }
            JLabel l = this.m_componentAvailableCascade;
            l.setIcon(icon);
            if (isSelected) {
                background = list.getSelectionBackground();
                foreground = list.getSelectionForeground();
            } else {
                background = list.getBackground();
                foreground = list.getForeground();
            }
            this.setSelectionColors(background, foreground);
            Vector cascadeName = cascade.getDecomposedCascadeName();
            this.m_componentConstraints.gridx = 0;
            this.m_componentConstraints.weightx = 0.0;
            this.m_componentPanel.add((Component)l, this.m_componentConstraints);
            while (cascadeName.size() > 1 && cascadeName.size() > cascade.getNumberOfOperatorsShown()) {
                cascadeName.removeElementAt(cascadeName.size() - 1);
            }
            String strActive = "";
            boolean bActive = false;
            if (JAPMixCascadeComboBox.this.m_currentCascade != null && JAPMixCascadeComboBox.this.m_currentCascade.getId().equals(cascade.getId()) && JAPMixCascadeComboBox.this.m_currentCascade != AbstractAutoSwitchedMixCascadeContainer.INITIAL_DUMMY_SERVICE) {
                bActive = true;
            }
            for (int i = 0; i < this.m_flags.length; ++i) {
                this.m_flags[i].setIcon(null);
                this.m_flags[i].setText("");
                this.m_names[i].setText("");
                int iFontSize = 0;
                if (bActive) {
                    iFontSize = 1;
                }
                this.m_flags[i].setFont(new Font(this.m_lblCascadePopupMenu.getFont().getName(), iFontSize, this.m_lblCascadePopupMenu.getFont().getSize()));
                this.m_names[i].setFont(this.m_flags[i].getFont());
            }
            Insets insetsLittleLeftSpace = new Insets(0, 2, 0, 0);
            for (int i = 0; i < cascadeName.size() && i < this.m_flags.length; ++i) {
                ++this.m_componentConstraints.gridx;
                this.m_names[i].setText((String)cascadeName.elementAt(i));
                this.m_componentPanel.add((Component)this.m_names[i], this.m_componentConstraints);
                if (i + 1 == cascade.getNumberOfOperatorsShown() || i + 1 == cascadeName.size()) {
                    this.m_componentConstraints.weightx = 1.0;
                    this.m_flags[i].setText(strActive);
                } else {
                    this.m_flags[i].setText("-");
                }
                ++this.m_componentConstraints.gridx;
                MixInfo mixInfo = cascadeName.size() == 1 ? cascade.getMixInfo(cascade.getNumberOfMixes() - 1) : cascade.getMixInfo(i);
                if (mixInfo != null && mixInfo.getCertPath() != null && mixInfo.getCertPath().getSubject() != null) {
                    String mixCountry = mixInfo.getCertPath().getSubject().getCountryCode();
                    this.m_flags[i].setIcon(GUIUtils.loadImageIcon("flags/" + mixCountry + ".png"));
                } else {
                    this.m_flags[i].setIcon(null);
                }
                Insets oldInsets = this.m_componentConstraints.insets;
                this.m_componentConstraints.insets = insetsLittleLeftSpace;
                this.m_componentPanel.add((Component)this.m_flags[i], this.m_componentConstraints);
                this.m_componentConstraints.insets = oldInsets;
            }
            return this.m_componentPanel;
        }

        private void setSelectionColors(Color a_background, Color a_foreground) {
            this.m_componentAvailableCascade.setBackground(a_background);
            this.m_componentAvailableCascade.setForeground(a_foreground);
            for (int i = 0; i < this.m_flags.length; ++i) {
                this.m_names[i].setBackground(a_background);
                this.m_names[i].setForeground(a_foreground);
                this.m_flags[i].setBackground(a_background);
                this.m_flags[i].setForeground(a_foreground);
            }
            this.m_componentPanel.setBackground(a_background);
            this.m_componentPanel.setForeground(a_foreground);
        }
    }

    final class JAPMixCascadeComboBoxModel
    extends DefaultComboBoxModel {
        JAPMixCascadeComboBoxModel() {
        }

        public void setSelectedItem(Object anObject) {
            if (anObject instanceof TrustModel) {
                boolean bSwitchTrust = false;
                boolean bSwitch = false;
                if (TrustModel.getCurrentTrustModel() == null || !TrustModel.getCurrentTrustModel().equals(anObject)) {
                    bSwitch = true;
                    bSwitchTrust = true;
                } else if (!JAPController.getInstance().getAnonMode() || !TrustModel.getCurrentTrustModel().isTrusted(JAPController.getInstance().getCurrentMixCascade())) {
                    bSwitch = true;
                    bSwitchTrust = false;
                } else if (TrustModel.getCurrentTrustModel().equals(anObject)) {
                    JAPMixCascadeComboBox.this.closeCascadePopupMenu();
                    return;
                }
                if (bSwitch) {
                    MixCascade selectedCascade = null;
                    for (int i = 0; i < this.getSize(); ++i) {
                        if (!(this.getElementAt(i) instanceof MixCascade)) continue;
                        selectedCascade = (MixCascade)this.getElementAt(i);
                        break;
                    }
                    if (selectedCascade != null) {
                        JAPMixCascadeComboBox.this.closeCascadePopupMenu();
                        super.setSelectedItem(selectedCascade);
                        if (bSwitchTrust) {
                            JAPController.getInstance().switchTrustFilter((TrustModel)anObject);
                        } else {
                            JAPController.getInstance().switchToNextMixCascade();
                        }
                    }
                }
                return;
            }
            if (anObject == null || anObject.equals(JAPMixCascadeComboBox.ITEM_NO_SERVERS_AVAILABLE) || anObject.equals(JAPMixCascadeComboBox.ITEM_AVAILABLE_SERVERS)) {
                return;
            }
            if (anObject instanceof MixCascade) {
                final MixCascade cascade = (MixCascade)anObject;
                final TrustModel model = TrustModel.getCurrentTrustModel();
                if (!JAPController.getInstance().getCurrentMixCascade().getId().equals(cascade.getId()) && !model.isTrusted(cascade) && JAPController.getInstance().getAnonMode()) {
                    new Thread(){

                        public void run() {
                            JAPConfAnon.showServiceUntrustedBox(cascade, JAPMixCascadeComboBox.this, model);
                        }
                    }.start();
                    JAPMixCascadeComboBox.this.closeCascadePopupMenu();
                    return;
                }
            }
            super.setSelectedItem(anObject);
        }
    }
}

