/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.infoservice.JavaVersionDBEntry;
import anon.infoservice.MixCascade;
import anon.infoservice.StatusInfo;
import anon.util.JAPMessages;
import anon.util.Util;
import gui.GUIUtils;
import gui.dialog.JAPDialog;
import jap.AbstractJAPMainView;
import jap.JAPController;
import jap.JAPModel;
import jap.JAPUtil;
import jap.SystrayPopupMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import logging.LogHolder;
import logging.LogType;

public final class JAPViewIconified
extends JWindow
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String XML_LOCATION = "IconifiedLocation";
    public static final String MSG_ANON_LOW = (class$jap$JAPViewIconified == null ? (class$jap$JAPViewIconified = JAPViewIconified.class$("jap.JAPViewIconified")) : class$jap$JAPViewIconified).getName() + "_anonLow";
    public static final String MSG_ANON_FAIR = (class$jap$JAPViewIconified == null ? (class$jap$JAPViewIconified = JAPViewIconified.class$("jap.JAPViewIconified")) : class$jap$JAPViewIconified).getName() + "_anonFair";
    public static final String MSG_ANON_HIGH = (class$jap$JAPViewIconified == null ? (class$jap$JAPViewIconified = JAPViewIconified.class$("jap.JAPViewIconified")) : class$jap$JAPViewIconified).getName() + "_anonHigh";
    public static final String MSG_ANON = (class$jap$JAPViewIconified == null ? (class$jap$JAPViewIconified = JAPViewIconified.class$("jap.JAPViewIconified")) : class$jap$JAPViewIconified).getName() + "_anon";
    private static final String IMG_16_DISCONNECTED = (class$jap$JAPViewIconified == null ? (class$jap$JAPViewIconified = JAPViewIconified.class$("jap.JAPViewIconified")) : class$jap$JAPViewIconified).getName() + "_icon16discon.gif";
    private static final String IMG_16_RED = (class$jap$JAPViewIconified == null ? (class$jap$JAPViewIconified = JAPViewIconified.class$("jap.JAPViewIconified")) : class$jap$JAPViewIconified).getName() + "_icon16red.gif";
    private static final String MSG_TT_SWITCH_ANONYMITY = (class$jap$JAPViewIconified == null ? (class$jap$JAPViewIconified = JAPViewIconified.class$("jap.JAPViewIconified")) : class$jap$JAPViewIconified).getName() + "_ttSwitchAnonymity";
    private static final String STR_HIDDEN_WINDOW = Double.toString(Math.random());
    private static JFrame m_frameParent;
    private JAPController m_Controller;
    private AbstractJAPMainView m_mainView;
    private JLabel m_labelBytes;
    private JLabel m_labelAnon;
    private JToggleButton m_lblJAPIcon;
    private JAPDialog ms_popupWindow;
    private JLabel m_lblBytes;
    private Font m_fontDlg;
    private NumberFormat m_NumberFormat;
    private boolean m_anonModeDisabled = false;
    private Object SYNC_CURSOR = new Object();
    private GUIUtils.WindowDocker m_docker;
    private Runnable m_runnableValueUpdate;
    static /* synthetic */ Class class$jap$JAPViewIconified;

    private static JFrame getParentFrame() {
        if (m_frameParent == null) {
            m_frameParent = new JFrame(STR_HIDDEN_WINDOW);
        }
        return m_frameParent;
    }

    public JAPViewIconified(AbstractJAPMainView a_mainView) {
        super(JAPViewIconified.getParentFrame());
        this.m_fontDlg = new Font("Sans", 1, 11);
        this.setName(STR_HIDDEN_WINDOW);
        this.m_mainView = a_mainView;
        if (m_frameParent != null) {
            m_frameParent.setIconImage(this.m_mainView.getIconImage());
        }
        LogHolder.log(6, LogType.MISC, "Initializing...");
        this.m_Controller = JAPController.getInstance();
        this.m_NumberFormat = NumberFormat.getInstance();
        this.m_runnableValueUpdate = new Runnable(){

            public void run() {
                JAPViewIconified.this.updateValues1();
            }
        };
        this.init();
    }

    private void init() {
        GridBagLayout la = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel pTop = new JPanel(la);
        pTop.setOpaque(false);
        this.m_lblBytes = new JLabel(JAPMessages.getString("iconifiedviewBytes") + ": ", 4);
        this.m_lblBytes.setFont(this.m_fontDlg);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 0.0;
        c.insets = new Insets(3, 3, 0, 0);
        c.anchor = 18;
        la.setConstraints(this.m_lblBytes, c);
        pTop.add(this.m_lblBytes);
        c.weightx = 1.0;
        this.m_labelBytes = new JLabel("000000,0", 2);
        this.m_labelBytes.setFont(this.m_fontDlg);
        c.gridx = 1;
        c.weightx = 0.0;
        la.setConstraints(this.m_labelBytes, c);
        pTop.add(this.m_labelBytes);
        JLabel tmpLabel = new JLabel(JAPMessages.getString(MSG_ANON) + ": ", 4);
        tmpLabel.setFont(this.m_fontDlg);
        ++c.gridy;
        c.gridx = 0;
        pTop.add((Component)tmpLabel, c);
        int anonLength = 0;
        anonLength = Math.max(anonLength, JAPMessages.getString(MSG_ANON_LOW).length());
        anonLength = Math.max(anonLength, JAPMessages.getString(MSG_ANON_FAIR).length());
        anonLength = Math.max(anonLength, JAPMessages.getString(MSG_ANON_HIGH).length());
        char[] charLength = new char[anonLength];
        for (int i = 0; i < charLength.length; ++i) {
            charLength[i] = 65;
        }
        this.m_labelAnon = new JLabel(new String(charLength), 2);
        this.m_labelAnon.setFont(this.m_fontDlg);
        ++c.gridx;
        pTop.add((Component)this.m_labelAnon, c);
        JButton bttn = new JButton(GUIUtils.loadImageIcon("enlarge.gif", true, false));
        bttn.setOpaque(false);
        bttn.addActionListener(this);
        bttn.setActionCommand("enlarge");
        bttn.setToolTipText(JAPMessages.getString("enlargeWindow"));
        JAPUtil.setMnemonic(bttn, JAPMessages.getString("iconifyButtonMn"));
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new LineBorder(Color.black, 1));
        p.add((Component)pTop, "Center");
        JPanel p2 = new JPanel(new BorderLayout());
        this.m_lblJAPIcon = new JToggleButton(GUIUtils.loadImageIcon("icon16.gif", true, false));
        this.m_lblJAPIcon.setPressedIcon(GUIUtils.loadImageIcon(IMG_16_DISCONNECTED, true, false));
        this.m_lblJAPIcon.setOpaque(false);
        this.m_lblJAPIcon.setToolTipText(JAPMessages.getString(MSG_TT_SWITCH_ANONYMITY));
        this.m_lblJAPIcon.addActionListener(this);
        this.m_lblJAPIcon.setActionCommand("switchanonymity");
        this.m_lblJAPIcon.setToolTipText(JAPMessages.getString(MSG_TT_SWITCH_ANONYMITY));
        this.m_lblJAPIcon.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseEntered(MouseEvent a_event) {
                Object object = JAPViewIconified.this.SYNC_CURSOR;
                synchronized (object) {
                    if (!JAPViewIconified.this.m_anonModeDisabled) {
                        JAPViewIconified.this.setCursor(Cursor.getPredefinedCursor(12));
                        JAPViewIconified.this.getRootPane().setToolTipText(JAPMessages.getString(MSG_TT_SWITCH_ANONYMITY));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseExited(MouseEvent e) {
                Object object = JAPViewIconified.this.SYNC_CURSOR;
                synchronized (object) {
                    JAPViewIconified.this.setCursor(Cursor.getPredefinedCursor(0));
                    JAPViewIconified.this.getRootPane().setToolTipText(null);
                }
            }
        });
        p2.add((Component)this.m_lblJAPIcon, "South");
        p2.add((Component)bttn, "North");
        p.add((Component)p2, "East");
        p.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent a_event) {
                if (SwingUtilities.isRightMouseButton(a_event) || a_event.isPopupTrigger()) {
                    SystrayPopupMenu popup = new SystrayPopupMenu(new SystrayPopupMenu.MainWindowListener(){

                        public void onShowMainWindow() {
                            JAPViewIconified.this.switchBackToMainView();
                        }

                        public void onShowSettings(String card, Object a_value) {
                            JAPViewIconified.this.m_mainView.showConfigDialog(card, a_value);
                        }

                        public void onShowHelp() {
                            JAPViewIconified.this.switchBackToMainView();
                        }
                    });
                    if (JavaVersionDBEntry.CURRENT_JAVA_VENDOR.toLowerCase().indexOf("sun") >= 0 && JavaVersionDBEntry.CURRENT_JAVA_VERSION.compareTo("1.6.0_02") >= 0) {
                        if (JAPViewIconified.this.ms_popupWindow == null) {
                            JAPViewIconified.this.ms_popupWindow = new JAPDialog(JAPViewIconified.this, STR_HIDDEN_WINDOW, false);
                            JAPViewIconified.this.ms_popupWindow.setName(STR_HIDDEN_WINDOW);
                            JAPViewIconified.this.ms_popupWindow.pack();
                            JAPViewIconified.this.ms_popupWindow.setLocation(20000, 20000);
                        }
                        JAPViewIconified.this.ms_popupWindow.setVisible(true);
                        popup.show(JAPViewIconified.this.ms_popupWindow.getContentPane(), JAPViewIconified.this, new Point(a_event.getX() + JAPViewIconified.this.getLocation().x, a_event.getY() + JAPViewIconified.this.getLocation().y));
                    } else {
                        popup.show(JAPViewIconified.this, new Point(a_event.getX() + JAPViewIconified.this.getLocation().x, a_event.getY() + JAPViewIconified.this.getLocation().y));
                    }
                } else if (a_event.getClickCount() > 1) {
                    JAPViewIconified.this.switchBackToMainView();
                }
            }
        });
        this.setContentPane(p);
        this.m_docker = new GUIUtils.WindowDocker(p);
        this.pack();
        GUIUtils.Screen currentScreen = GUIUtils.getCurrentScreen(this);
        if (this.getSize().width > currentScreen.getWidth() || this.getSize().height > currentScreen.getHeight()) {
            LogHolder.log(3, LogType.GUI, "Packed iconified view with illegal size! Width:" + this.getSize().width + " Height:" + this.getSize().height + "\nSetting defaults...");
            if (JAPModel.getInstance().getIconifiedSize() != null && JAPModel.getInstance().getIconifiedSize().width > 0 && JAPModel.getInstance().getIconifiedSize().height > 0) {
                this.setSize(JAPModel.getInstance().getIconifiedSize());
            } else {
                this.setSize(new Dimension(151, 85));
            }
        } else {
            JAPModel.getInstance().setIconifiedSize(this.getSize());
        }
        GUIUtils.moveToUpRightCorner(this);
        GUIUtils.restoreLocation(this, JAPModel.getInstance().getIconifiedWindowLocation());
        this.m_labelBytes.setText(Util.formatBytesValueWithoutUnit(0L));
        this.m_lblBytes.setText(Util.formatBytesValueOnlyUnit(0L) + ": ");
        this.m_labelAnon.setText(JAPMessages.getString("iconifiedViewNA"));
    }

    public void setVisible(boolean a_bVisible) {
        if (a_bVisible) {
            GUIUtils.setAlwaysOnTop(this, JAPModel.getInstance().isMiniViewOnTop());
        }
        JAPController.getInstance().switchViewWindow(!a_bVisible);
        super.setVisible(a_bVisible);
    }

    public void switchBackToMainView() {
        if (this.m_mainView == null || !this.isVisible() && this.m_mainView.isVisible()) {
            return;
        }
        this.m_mainView.setVisible(true);
        this.setVisible(false);
        this.m_mainView.toFront();
    }

    public void actionPerformed(ActionEvent event) {
        if ("enlarge".equals(event.getActionCommand())) {
            this.switchBackToMainView();
        } else if ("switchanonymity".equals(event.getActionCommand())) {
            if (this.m_Controller.getAnonMode()) {
                this.m_Controller.stop();
            } else {
                this.m_Controller.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValues1() {
        Runnable runnable = this.m_runnableValueUpdate;
        synchronized (runnable) {
            block12: {
                try {
                    if (this.m_Controller.isAnonConnected()) {
                        MixCascade currentMixCascade = this.m_Controller.getCurrentMixCascade();
                        StatusInfo currentStatus = currentMixCascade.getCurrentStatus();
                        int anonLevel = currentStatus.getAnonLevel();
                        this.m_labelAnon.setText(currentMixCascade.getDistribution() + "," + (anonLevel < 0 ? "?" : "" + anonLevel) + " / " + 6 + "," + 6);
                        JToggleButton jToggleButton = this.m_lblJAPIcon;
                        synchronized (jToggleButton) {
                            String iconPath = JAPModel.getInstance().getProgramName().equals("JonDo") ? "JonDo.ico.gif" : "icon16.gif";
                            this.m_lblJAPIcon.setIcon(GUIUtils.loadImageIcon(iconPath, true, false));
                            this.m_lblJAPIcon.getModel().setSelected(false);
                            break block12;
                        }
                    }
                    this.m_labelAnon.setText(JAPMessages.getString("iconifiedViewNA"));
                    JToggleButton currentMixCascade = this.m_lblJAPIcon;
                    synchronized (currentMixCascade) {
                        this.m_lblJAPIcon.setIcon(GUIUtils.loadImageIcon(IMG_16_DISCONNECTED, true, false));
                        this.m_lblJAPIcon.getModel().setSelected(true);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void dispose() {
        this.m_docker.finalize();
        super.dispose();
    }

    public void disableSetAnonMode() {
        this.m_anonModeDisabled = true;
        this.m_lblJAPIcon.getModel().setEnabled(false);
    }

    public void updateValues(boolean bSync) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_runnableValueUpdate.run();
        } else {
            try {
                if (bSync) {
                    SwingUtilities.invokeAndWait(this.m_runnableValueUpdate);
                }
            }
            catch (InvocationTargetException ex) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(this.m_runnableValueUpdate);
        }
    }

    public void channelsChanged(int c) {
    }

    public void packetMixed(final long a_totalBytes) {
        Runnable updateThread = new Runnable(){

            public void run() {
                JAPViewIconified.this.m_lblBytes.setText(Util.formatBytesValueOnlyUnit(a_totalBytes) + ":");
                JAPViewIconified.this.m_labelBytes.setText(Util.formatBytesValueWithoutUnit(a_totalBytes));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            updateThread.run();
        } else {
            SwingUtilities.invokeLater(updateThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blink() {
        if (this.isVisible()) {
            JToggleButton jToggleButton = this.m_lblJAPIcon;
            synchronized (jToggleButton) {
                if (this.m_Controller.isAnonConnected()) {
                    this.m_lblJAPIcon.setIcon(GUIUtils.loadImageIcon(IMG_16_RED, true, false));
                    try {
                        this.m_lblJAPIcon.wait(250L);
                    }
                    catch (InterruptedException a_e) {
                        // empty catch block
                    }
                }
                if (this.m_Controller.isAnonConnected()) {
                    String iconPath = JAPModel.getInstance().getProgramName().equals("JonDo") ? "JonDo.ico.gif" : "icon16.gif";
                    this.m_lblJAPIcon.setIcon(GUIUtils.loadImageIcon(iconPath, true, false));
                    this.m_lblJAPIcon.getModel().setSelected(false);
                } else {
                    this.m_lblJAPIcon.setIcon(GUIUtils.loadImageIcon(IMG_16_DISCONNECTED, true, false));
                    this.m_lblJAPIcon.getModel().setSelected(true);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

