/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.ModuleException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;

public class RetryAfterModule
implements HTTPClientModule,
GlobalConstants {
    private static int threshold;
    private static Hashtable retry_list;
    private int delay = -1;

    RetryAfterModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        Object dly;
        if (req.getStream() != null && (dly = retry_list.get(req.getStream())) != null) {
            this.delay = (Integer)dly;
            retry_list.remove(req.getStream());
        }
        if (this.delay > threshold) {
            if (GlobalConstants.DebugMods) {
                Util.logLine("ReAfM: delay exceeds threshold (" + this.delay + " > " + threshold + ") - aborting request");
            }
            return 4;
        }
        if (this.delay >= 0) {
            if (GlobalConstants.DebugMods) {
                Util.logLine("ReAfM: delaying request by " + this.delay + " sec");
            }
            try {
                Thread.sleep((long)this.delay * 1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.delay = -1;
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        block9: {
            this.delay = -1;
            if (resp.getHeader("Retry-After") == null) {
                return;
            }
            try {
                this.delay = resp.getHeaderAsInt("Retry-After");
            }
            catch (NumberFormatException nfe) {
                Date date;
                Date ra;
                try {
                    ra = resp.getHeaderAsDate("Retry-After");
                }
                catch (IllegalArgumentException iae) {
                    throw new ModuleException("Illegal value in Retry-After header: '" + resp.getHeader("Retry-After") + "'");
                }
                if (ra == null) {
                    return;
                }
                try {
                    date = resp.getHeaderAsDate("Date");
                }
                catch (IllegalArgumentException iae) {
                    throw new ModuleException("Illegal value in Date header: '" + resp.getHeader("Date") + "'");
                }
                if (date == null) {
                    date = new Date();
                }
                this.delay = (int)((ra.getTime() - date.getTime()) / 1000L);
                if (!GlobalConstants.DebugMods) break block9;
                Util.logLine("ReAfM: delay = " + this.delay + " sec");
            }
        }
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        if (resp.getStatusCode() == 503 && this.delay >= 0) {
            if (this.delay > threshold) {
                if (GlobalConstants.DebugMods) {
                    Util.logLine("ReAfM: delay exceeds threshold (" + this.delay + " > " + threshold + ") - not retrying request");
                }
                return 10;
            }
            if (req.getStream() != null) {
                retry_list.put(req.getStream(), new Integer(this.delay));
                req.getStream().reset();
                resp.setRetryRequest(true);
                return 10;
            }
            if (GlobalConstants.DebugMods) {
                Util.logLine("ReAfM: handling 503 status - retrying request");
            }
            return 13;
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }

    public static void setThreshold(int secs) {
        threshold = secs;
    }

    static {
        retry_list = new Hashtable();
        try {
            threshold = Integer.getInteger("HTTPClient.retryafter.threshold", 30);
        }
        catch (Exception e) {
            threshold = 30;
        }
    }
}

