/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;

public final class MyECParams {
    private static final ASN1ObjectIdentifier IMPLICIT_CURVE_ID = SECObjectIdentifiers.secp160r1;
    ECDomainParameters m_params;
    boolean m_isImplicitlyCA = false;
    boolean m_isNamedCurve = false;
    ASN1ObjectIdentifier m_curveIdentifier = null;

    public MyECParams() {
        this(SECNamedCurves.getByOID(IMPLICIT_CURVE_ID));
        this.m_isImplicitlyCA = true;
    }

    public MyECParams(ECDomainParameters params) {
        this.m_params = params;
    }

    public MyECParams(X9ECParameters x9params) {
        this.m_params = new ECDomainParameters(x9params.getCurve(), x9params.getG(), x9params.getN(), x9params.getH());
    }

    public MyECParams(X962Parameters params) {
        X9ECParameters x9params = null;
        if (params.isNamedCurve()) {
            this.m_isNamedCurve = true;
            this.m_curveIdentifier = (ASN1ObjectIdentifier)params.getParameters();
            x9params = SECNamedCurves.getByOID(this.m_curveIdentifier);
            if (x9params == null) {
                x9params = X962NamedCurves.getByOID(this.m_curveIdentifier);
            }
            if (x9params == null) {
                x9params = NISTNamedCurves.getByOID(this.m_curveIdentifier);
            }
            if (x9params == null) {
                x9params = TeleTrusTNamedCurves.getByOID(this.m_curveIdentifier);
            }
            if (x9params == null) {
                throw new IllegalArgumentException("Unknown Named Curve Identifier!");
            }
        } else if (params.isImplicitlyCA()) {
            this.m_isImplicitlyCA = true;
            x9params = SECNamedCurves.getByOID(IMPLICIT_CURVE_ID);
            this.m_curveIdentifier = IMPLICIT_CURVE_ID;
        } else {
            x9params = X9ECParameters.getInstance(params.getParameters());
            this.m_isNamedCurve = false;
        }
        this.m_params = new ECDomainParameters(x9params.getCurve(), x9params.getG(), x9params.getN(), x9params.getH());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ECDomainParameters)) {
            return false;
        }
        ECDomainParameters e = (ECDomainParameters)o;
        if (e.getH().equals(this.m_params.getH()) && e.getN().equals(this.m_params.getN())) {
            if (e.getCurve() instanceof ECCurve.F2m) {
                return ((ECCurve.F2m)e.getCurve()).equals(this.m_params.getCurve());
            }
            if (e.getCurve() instanceof ECCurve.Fp) {
                return ((ECCurve.Fp)e.getCurve()).equals(this.m_params.getCurve());
            }
        }
        return false;
    }

    protected ECDomainParameters getECDomainParams() {
        return this.m_params;
    }

    protected X962Parameters getX962Params() {
        if (this.m_isNamedCurve) {
            return new X962Parameters(this.m_curveIdentifier);
        }
        if (this.m_isImplicitlyCA) {
            return new X962Parameters(DERNull.INSTANCE);
        }
        X9ECParameters x9params = new X9ECParameters(this.m_params.getCurve(), this.m_params.getG(), this.m_params.getN(), this.m_params.getH());
        return new X962Parameters(x9params);
    }

    protected void setNamedCurveID(ASN1ObjectIdentifier curveIdentifier) {
        if (curveIdentifier != null) {
            this.m_curveIdentifier = curveIdentifier;
            this.m_isNamedCurve = true;
        }
    }

    protected ASN1ObjectIdentifier getCurveID() {
        return this.m_curveIdentifier;
    }
}

