/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.pay.PayAccount;
import anon.pay.xml.XMLBalance;
import anon.pay.xml.XMLEasyCC;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLAccountInfo
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "AccountInfo";
    public static final String XML_ELEMENT_NAME_COST_CONFIRMATIONS = "CostConfirmations";
    private XMLBalance m_balance = null;
    private PayAccount m_callbackAccount;
    private Hashtable m_costConfirmations = new Hashtable();
    private Hashtable m_pastMonthlyVolumeBytes = new Hashtable();
    private Timestamp m_tLastBalanceUpdate = new Timestamp(0L);

    public XMLAccountInfo(XMLBalance bal) {
        this.m_balance = bal;
        if (this.m_balance != null) {
            this.m_tLastBalanceUpdate = new Timestamp(System.currentTimeMillis());
        }
    }

    public XMLAccountInfo(String xml) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xml);
        this.setValues(doc.getDocumentElement());
    }

    public XMLAccountInfo() {
    }

    public XMLAccountInfo(Element xml) throws Exception {
        this.setValues(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        Enumeration enumer;
        Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME);
        elemRoot.setAttribute("version", "1.1");
        XMLUtil.setAttribute(elemRoot, "lastBalanceUpdate", this.m_tLastBalanceUpdate.toString());
        Element elem = this.m_balance.toXmlElement(a_doc);
        elemRoot.appendChild(elem);
        Element elemCCs = a_doc.createElement(XML_ELEMENT_NAME_COST_CONFIRMATIONS);
        elemRoot.appendChild(elemCCs);
        Hashtable hashtable = this.m_costConfirmations;
        synchronized (hashtable) {
            enumer = this.m_costConfirmations.elements();
            while (enumer.hasMoreElements()) {
                XMLEasyCC cc = (XMLEasyCC)enumer.nextElement();
                elem = cc.toXmlElement(a_doc);
                elemCCs.appendChild(elem);
            }
        }
        elemCCs = a_doc.createElement("PastMonthsVolumeBytesContainer");
        elemRoot.appendChild(elemCCs);
        hashtable = this.m_pastMonthlyVolumeBytes;
        synchronized (hashtable) {
            enumer = this.m_pastMonthlyVolumeBytes.elements();
            while (enumer.hasMoreElements()) {
                PastMonthsVolumeBytes pastBytes = (PastMonthsVolumeBytes)enumer.nextElement();
                elem = pastBytes.toXmlElement(a_doc);
                elemCCs.appendChild(elem);
            }
        }
        return elemRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addCC(XMLEasyCC a_cc, boolean a_bForcedAdd) {
        long oldBytes = 0L;
        Hashtable hashtable = this.m_costConfirmations;
        synchronized (hashtable) {
            XMLEasyCC cc = (XMLEasyCC)this.m_costConfirmations.get(a_cc.getConcatenatedPriceCertHashes());
            if (cc != null) {
                oldBytes = cc.getTransferredBytes();
            }
            if (a_bForcedAdd || a_cc.getTransferredBytes() >= oldBytes) {
                this.m_costConfirmations.put(a_cc.getConcatenatedPriceCertHashes(), a_cc);
            }
        }
        return a_cc.getTransferredBytes() - oldBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPastMonthlyVolumeBytes(XMLAccountInfo a_info) throws Exception {
        Hashtable hashtable = this.m_pastMonthlyVolumeBytes;
        synchronized (hashtable) {
            Enumeration enumBytes = a_info.m_pastMonthlyVolumeBytes.elements();
            while (enumBytes.hasMoreElements()) {
                PastMonthsVolumeBytes pastBytes = (PastMonthsVolumeBytes)enumBytes.nextElement();
                this.m_pastMonthlyVolumeBytes.put(pastBytes.getConcatenatedPriceCertHashes(), pastBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPastMonthlyVolumeBytes(PastMonthsVolumeBytes a_monthlyBytes) {
        Timestamp lastUpdate = new Timestamp(0L);
        Hashtable hashtable = this.m_pastMonthlyVolumeBytes;
        synchronized (hashtable) {
            PastMonthsVolumeBytes cc = (PastMonthsVolumeBytes)this.m_pastMonthlyVolumeBytes.get(a_monthlyBytes.getConcatenatedPriceCertHashes());
            if (cc != null) {
                lastUpdate = cc.getUpdatedOn();
            }
            if (a_monthlyBytes.getUpdatedOn() != null && a_monthlyBytes.getUpdatedOn().getTime() >= lastUpdate.getTime()) {
                this.m_pastMonthlyVolumeBytes.put(a_monthlyBytes.getConcatenatedPriceCertHashes(), a_monthlyBytes);
            }
        }
    }

    private void setValues(Element elemRoot) throws Exception {
        if (!elemRoot.getTagName().equals(XML_ELEMENT_NAME)) {
            LogHolder.log(2, LogType.PAY, "invalid XML structure: " + XMLUtil.toString(elemRoot));
            throw new Exception("XMLAccountInfo wrong XML structure");
        }
        Element elemBalance = (Element)XMLUtil.getFirstChildByName(elemRoot, "Balance");
        this.m_balance = new XMLBalance(elemBalance);
        this.m_tLastBalanceUpdate = Timestamp.valueOf(XMLUtil.parseAttribute((Node)elemRoot, "lastBalanceUpdate", this.m_balance.getTimestamp().toString()));
        Element elemCCs = (Element)XMLUtil.getFirstChildByName(elemRoot, XML_ELEMENT_NAME_COST_CONFIRMATIONS);
        Element elemCC = (Element)XMLUtil.getFirstChildByName(elemCCs, "CC");
        XMLEasyCC cc = null;
        while (elemCC != null) {
            cc = new XMLEasyCC(elemCC);
            this.m_costConfirmations.put(cc.getConcatenatedPriceCertHashes(), cc);
            elemCC = (Element)XMLUtil.getNextSiblingByName(elemCC, "CC");
        }
        Element elemPastBytesContainer = (Element)XMLUtil.getFirstChildByName(elemRoot, "PastMonthsVolumeBytesContainer");
        Element elemPastBytes = (Element)XMLUtil.getFirstChildByName(elemPastBytesContainer, "PastMonthsVolumeBytes");
        PastMonthsVolumeBytes pastbytes = null;
        while (elemPastBytes != null) {
            pastbytes = new PastMonthsVolumeBytes(elemPastBytes);
            this.m_pastMonthlyVolumeBytes.put(pastbytes.getConcatenatedPriceCertHashes(), pastbytes);
            elemPastBytes = (Element)XMLUtil.getNextSiblingByName(elemPastBytes, "PastMonthsVolumeBytes");
        }
    }

    public XMLBalance getBalance() {
        return this.m_balance;
    }

    public XMLEasyCC getCC(String priceCertHash) {
        return (XMLEasyCC)this.m_costConfirmations.get(priceCertHash);
    }

    public void setAccountCallback(PayAccount a_callbackAccount) {
        this.m_callbackAccount = a_callbackAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMonthlyBytesUpdatedOn() {
        if (this.m_balance != null && this.m_balance.getVolumeBytesMonthly() > 0L) {
            Timestamp tNow = new Timestamp(System.currentTimeMillis());
            Hashtable hashtable = this.m_costConfirmations;
            synchronized (hashtable) {
                Hashtable hashtable2 = this.m_pastMonthlyVolumeBytes;
                synchronized (hashtable2) {
                    if (!(XMLBalance.isSameMonthlyPeriod(this.m_balance.getMonthlyBytesUpdatedOn(), tNow, this.m_balance.getStartDate(), true) || XMLBalance.isSameMonthlyPeriod(this.m_tLastBalanceUpdate, tNow, this.m_balance.getStartDate(), true) || XMLBalance.isSameMonthlyPeriod(this.m_balance.getStartDate(), tNow, this.m_balance.getStartDate(), true))) {
                        Enumeration enumCCs = this.getCCs();
                        while (enumCCs.hasMoreElements()) {
                            XMLEasyCC cc = (XMLEasyCC)enumCCs.nextElement();
                            PastMonthsVolumeBytes pastBytes = (PastMonthsVolumeBytes)this.m_pastMonthlyVolumeBytes.get(cc.getPriceCertHashes());
                            if (pastBytes != null && XMLBalance.isSameMonthlyPeriod(pastBytes.getUpdatedOn(), tNow, this.m_balance.getStartDate(), true)) continue;
                            pastBytes = new PastMonthsVolumeBytes(cc.getConcatenatedPriceCertHashes(), cc.getTransferredBytes(), tNow);
                            this.m_pastMonthlyVolumeBytes.put(pastBytes.getConcatenatedPriceCertHashes(), pastBytes);
                        }
                        PayAccount callbackAccount = this.m_callbackAccount;
                        if (callbackAccount != null) {
                            callbackAccount.fireChangeEvent();
                        }
                    }
                }
            }
        }
    }

    public Enumeration getCCs() {
        return ((Hashtable)this.m_costConfirmations.clone()).elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAllCCsTransferredBytes() {
        long sum = 0L;
        Hashtable hashtable = this.m_costConfirmations;
        synchronized (hashtable) {
            Hashtable hashtable2 = this.m_pastMonthlyVolumeBytes;
            synchronized (hashtable2) {
                Enumeration e = this.m_costConfirmations.elements();
                while (e.hasMoreElements()) {
                    XMLEasyCC cc = (XMLEasyCC)e.nextElement();
                    PastMonthsVolumeBytes pastBytes = (PastMonthsVolumeBytes)this.m_pastMonthlyVolumeBytes.get(cc.getConcatenatedPriceCertHashes());
                    long lPastBytes = pastBytes == null ? 0L : pastBytes.getBytes();
                    sum += cc.getTransferredBytes() - lPastBytes;
                }
            }
        }
        return sum;
    }

    public void setBalance(XMLBalance b1) {
        this.m_balance = b1;
        if (this.m_balance != null) {
            this.m_tLastBalanceUpdate = new Timestamp(System.currentTimeMillis());
        }
    }

    public Timestamp getLastBalanceUpdateLocalTime() {
        return this.m_tLastBalanceUpdate;
    }

    public XMLAccountInfo(Document document) throws Exception {
        this.setValues(document.getDocumentElement());
        this.m_tLastBalanceUpdate = new Timestamp(System.currentTimeMillis());
    }

    public static class PastMonthsVolumeBytes
    implements IXMLEncodable {
        public static final String XML_ELEMENT_NAME_PMB = "PastMonthsVolumeBytes";
        private long m_lBytes = 0L;
        private String m_strPriceCertHashes = null;
        private Timestamp m_tUpdatedOn = null;

        public PastMonthsVolumeBytes(String a_strPriceCertHashes, long a_lBytes, Timestamp a_tUpdatedOn) {
            if (a_lBytes < 0L) {
                throw new IllegalArgumentException("Past Bytes may not be < 0!");
            }
            if (a_strPriceCertHashes == null) {
                throw new IllegalArgumentException("Price cert hashed may not be null!");
            }
            this.m_strPriceCertHashes = a_strPriceCertHashes;
            this.m_lBytes = a_lBytes;
            this.m_tUpdatedOn = a_tUpdatedOn;
        }

        public PastMonthsVolumeBytes(Element a_elem) throws XMLParseException {
            XMLUtil.assertNodeName(a_elem, XML_ELEMENT_NAME_PMB);
            this.m_strPriceCertHashes = XMLUtil.parseAttribute((Node)a_elem, "priceCertHashes", null);
            if (this.m_strPriceCertHashes == null) {
                throw new XMLParseException("priceCertHashes", "##__null__##");
            }
            this.m_tUpdatedOn = new Timestamp(XMLUtil.parseAttribute((Node)a_elem, "updatedOn", 0L));
            this.m_lBytes = XMLUtil.parseValue((Node)a_elem, 0L);
        }

        public long getBytes() {
            return this.m_lBytes;
        }

        public void setUpdatedOn(Timestamp a_tUpdatedOn) {
            this.m_tUpdatedOn = a_tUpdatedOn;
        }

        public String getConcatenatedPriceCertHashes() {
            return this.m_strPriceCertHashes;
        }

        public Timestamp getUpdatedOn() {
            return this.m_tUpdatedOn;
        }

        public Element toXmlElement(Document a_doc) {
            Element elem = a_doc.createElement(XML_ELEMENT_NAME_PMB);
            XMLUtil.setAttribute(elem, "priceCertHashes", this.m_strPriceCertHashes);
            XMLUtil.setAttribute(elem, "updatedOn", this.m_tUpdatedOn.getTime());
            XMLUtil.setValue((Node)elem, this.m_lBytes);
            return elem;
        }
    }
}

