/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.PKCS12;
import anon.crypto.XMLSignature;
import anon.infoservice.MixPosition;
import anon.util.IXMLEncodable;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLEasyCC
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "CC";
    private long m_lTransferredBytes;
    private long m_lAccountNumber;
    private int m_id = 0;
    private Hashtable m_priceCerts = new Hashtable();
    private String m_cascadeID;
    private Document m_docTheEasyCC;
    private String m_priceCertHashesConcatenated;
    private boolean m_bOldHashFormat = false;
    private boolean m_bIsLastCC = false;
    private String m_strPIID;

    public XMLEasyCC(long accountNumber, long transferred, PKCS12 a_certificate, Hashtable a_priceCerts, String a_AiName, String a_strPIID) throws XMLParseException {
        this.m_priceCerts = a_priceCerts;
        this.m_priceCertHashesConcatenated = XMLEasyCC.createConcatenatedPriceCertHashes(a_priceCerts, true);
        this.m_lTransferredBytes = transferred;
        this.m_lAccountNumber = accountNumber;
        this.m_cascadeID = a_AiName;
        this.m_strPIID = a_strPIID;
        this.m_docTheEasyCC = XMLUtil.createDocument();
        this.m_docTheEasyCC.appendChild(this.internal_toXmlElement(this.m_docTheEasyCC));
        if (a_certificate != null) {
            XMLSignature.sign((Node)this.m_docTheEasyCC, a_certificate, 0);
        }
    }

    public XMLEasyCC(byte[] data) throws Exception {
        Document doc = XMLUtil.toXMLDocument(data);
        this.setValues(doc.getDocumentElement());
        this.m_docTheEasyCC = doc;
    }

    public XMLEasyCC(String xml) throws XMLParseException {
        Document doc = XMLUtil.toXMLDocument(xml);
        this.setValues(doc.getDocumentElement());
        this.m_docTheEasyCC = doc;
    }

    public XMLEasyCC(char[] data) throws XMLParseException {
        this(new String(data));
    }

    public XMLEasyCC(Element xml) throws Exception {
        this.setValues(xml);
        this.m_docTheEasyCC = XMLUtil.createDocument();
        this.m_docTheEasyCC.appendChild(XMLUtil.importNode(this.m_docTheEasyCC, xml, true));
    }

    public XMLEasyCC(XMLEasyCC a_copiedCc) throws XMLParseException {
        this.m_lTransferredBytes = a_copiedCc.m_lTransferredBytes;
        this.m_lAccountNumber = a_copiedCc.m_lAccountNumber;
        a_copiedCc.m_id = 0;
        this.m_id = 0;
        this.m_priceCerts = (Hashtable)a_copiedCc.m_priceCerts.clone();
        this.m_cascadeID = a_copiedCc.m_cascadeID;
        this.m_docTheEasyCC = XMLUtil.createDocument();
        this.m_docTheEasyCC.appendChild(XMLUtil.importNode(this.m_docTheEasyCC, a_copiedCc.m_docTheEasyCC.getDocumentElement(), true));
        this.m_priceCertHashesConcatenated = a_copiedCc.m_priceCertHashesConcatenated;
        this.m_strPIID = a_copiedCc.m_strPIID;
    }

    private void setValues(Element element) throws XMLParseException {
        if (!element.getTagName().equals(XML_ELEMENT_NAME)) {
            throw new XMLParseException("XMLEasyCC wrong xml root element name");
        }
        String strVersion = XMLUtil.parseAttribute((Node)element, "version", null);
        if (strVersion == null || !strVersion.equals("1.2") && !strVersion.equals("1.1")) {
            throw new XMLParseException("XMLEasyCC wrong version");
        }
        Element elem = (Element)XMLUtil.getFirstChildByName(element, "AccountNumber");
        this.m_lAccountNumber = XMLUtil.parseValue((Node)elem, 0L);
        elem = (Element)XMLUtil.getFirstChildByName(element, "TransferredBytes");
        this.m_lTransferredBytes = XMLUtil.parseValue((Node)elem, -1L);
        this.m_bIsLastCC = XMLUtil.parseAttribute((Node)elem, "isLastCC", this.m_bIsLastCC);
        elem = (Element)XMLUtil.getFirstChildByName(element, "PIID");
        this.m_strPIID = XMLUtil.parseValue((Node)elem, (String)null);
        elem = (Element)XMLUtil.getFirstChildByName(element, "Cascade");
        this.m_cascadeID = XMLUtil.parseValue((Node)elem, (String)null);
        Element elemPriceCerts = (Element)XMLUtil.getFirstChildByName(element, "PriceCertificates");
        if (elemPriceCerts != null) {
            NodeList allHashes = elemPriceCerts.getElementsByTagName("PriceCertHash");
            for (int i = 0; i < allHashes.getLength(); ++i) {
                Element elemHash = (Element)allHashes.item(i);
                String curHash = XMLUtil.parseValue((Node)elemHash, "abc");
                String curId = XMLUtil.parseAttribute((Node)elemHash, "id", "abc");
                if (curId.equals("abc")) {
                    throw new XMLParseException("wrong or missing id of price certificate");
                }
                int position = XMLUtil.parseAttribute((Node)elemHash, "position", -1);
                if (position < 0) {
                    this.m_bOldHashFormat = true;
                }
                this.m_priceCerts.put(new MixPosition(position, curId), curHash);
            }
        }
        this.m_priceCertHashesConcatenated = XMLEasyCC.createConcatenatedPriceCertHashes(this.m_priceCerts, !this.m_bOldHashFormat);
        if (this.m_bOldHashFormat) {
            LogHolder.log(4, LogType.PAY, "Found old hash format for CC: " + this.m_priceCertHashesConcatenated);
        }
    }

    private Element internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME);
        elemRoot.setAttribute("version", "1.2");
        Element elem = a_doc.createElement("TransferredBytes");
        XMLUtil.setValue((Node)elem, Long.toString(this.m_lTransferredBytes));
        XMLUtil.setAttribute(elem, "isLastCC", this.m_bIsLastCC);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("AccountNumber");
        XMLUtil.setValue((Node)elem, Long.toString(this.m_lAccountNumber));
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("PIID");
        if (this.m_strPIID != null) {
            XMLUtil.setValue((Node)elem, this.m_strPIID);
        }
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Cascade");
        if (this.m_cascadeID != null) {
            XMLUtil.setValue((Node)elem, this.m_cascadeID);
        }
        elemRoot.appendChild(elem);
        Element elemPriceCerts = a_doc.createElement("PriceCertificates");
        elemRoot.appendChild(elemPriceCerts);
        Enumeration certs = this.m_priceCerts.keys();
        while (certs.hasMoreElements()) {
            MixPosition curId = (MixPosition)certs.nextElement();
            String curHash = (String)this.m_priceCerts.get(curId);
            Element curElem = a_doc.createElement("PriceCertHash");
            XMLUtil.setValue((Node)curElem, curHash);
            XMLUtil.setAttribute(curElem, "id", curId.getId());
            if (!this.m_bOldHashFormat) {
                XMLUtil.setAttribute(curElem, "position", curId.getPosition());
            }
            elemPriceCerts.appendChild(curElem);
        }
        return elemRoot;
    }

    public String getPIID() {
        return this.m_strPIID;
    }

    public synchronized void setPIID(String a_piID) {
        this.m_strPIID = a_piID;
        this.m_docTheEasyCC = XMLUtil.createDocument();
        this.m_docTheEasyCC.appendChild(this.internal_toXmlElement(this.m_docTheEasyCC));
    }

    public int getId() {
        return this.m_id;
    }

    public void setId(int a_id) {
        this.m_id = a_id;
    }

    public void setCascadeID(String a_id) {
        this.m_cascadeID = a_id;
        this.m_docTheEasyCC = XMLUtil.createDocument();
        this.m_docTheEasyCC.appendChild(this.internal_toXmlElement(this.m_docTheEasyCC));
    }

    public long getAccountNumber() {
        return this.m_lAccountNumber;
    }

    public long getTransferredBytes() {
        return this.m_lTransferredBytes;
    }

    public Enumeration getMixIds() {
        Enumeration mixPositions = this.m_priceCerts.keys();
        Hashtable keysOnly = new Hashtable();
        while (mixPositions.hasMoreElements()) {
            MixPosition curPos = (MixPosition)mixPositions.nextElement();
            String curId = curPos.getId();
            keysOnly.put(curId, this.m_priceCerts.get(curPos));
        }
        return keysOnly.keys();
    }

    public String getCascadeID() {
        return this.m_cascadeID;
    }

    public Hashtable getPriceCertHashes() {
        return (Hashtable)this.m_priceCerts.clone();
    }

    public String getConcatenatedPriceCertHashes() {
        return this.m_priceCertHashesConcatenated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createConcatenatedPriceCertHashes(Hashtable priceCerts, boolean newFormat) {
        StringBuffer priceCertHashesConcatenated = new StringBuffer();
        if (priceCerts != null) {
            Hashtable hashtable = priceCerts;
            synchronized (hashtable) {
                int i;
                String[] ids = new String[priceCerts.size()];
                String[] hashes = new String[priceCerts.size()];
                Enumeration enumer = priceCerts.keys();
                for (i = 0; i < priceCerts.size(); ++i) {
                    Object currentKey = enumer.nextElement();
                    ids[i] = !newFormat ? ((MixPosition)currentKey).getId() : Integer.toString(((MixPosition)currentKey).getPosition());
                    hashes[i] = priceCerts.get(currentKey).toString();
                }
                if (!newFormat) {
                    Util.sort(hashes, ids);
                } else {
                    Util.sort(ids, hashes);
                }
                for (i = 0; i < hashes.length; ++i) {
                    priceCertHashesConcatenated.append(hashes[i]);
                }
            }
        }
        return priceCertHashesConcatenated.toString();
    }

    public int getNrOfPriceCerts() {
        return this.m_priceCerts.size();
    }

    public boolean isLastCC() {
        return this.m_bIsLastCC;
    }

    public void setLastCC(boolean a_bIsLastCC) {
        this.m_bIsLastCC = a_bIsLastCC;
    }

    public void setPriceCerts(Hashtable a_priceCertHashes) {
        this.m_bOldHashFormat = false;
        this.m_priceCerts = a_priceCertHashes;
        this.m_priceCertHashesConcatenated = XMLEasyCC.createConcatenatedPriceCertHashes(this.m_priceCerts, !this.m_bOldHashFormat);
        if (this.m_bOldHashFormat) {
            LogHolder.log(4, LogType.PAY, "Found old hash format for CC: " + this.m_priceCertHashesConcatenated);
        }
        this.m_docTheEasyCC = XMLUtil.createDocument();
        this.m_docTheEasyCC.appendChild(this.internal_toXmlElement(this.m_docTheEasyCC));
    }

    public synchronized void addTransferredBytes(long plusBytes) {
        this.m_lTransferredBytes += plusBytes;
        this.m_docTheEasyCC = XMLUtil.createDocument();
        this.m_docTheEasyCC.appendChild(this.internal_toXmlElement(this.m_docTheEasyCC));
    }

    public synchronized void setTransferredBytes(long numBytes) {
        this.m_lTransferredBytes = numBytes;
        this.m_docTheEasyCC = XMLUtil.createDocument();
        this.m_docTheEasyCC.appendChild(this.internal_toXmlElement(this.m_docTheEasyCC));
    }

    public boolean sign(IMyPrivateKey key) {
        try {
            XMLSignature.sign((Node)this.m_docTheEasyCC, key, 0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verify(IMyPublicKey key) {
        try {
            return XMLSignature.verifyFast((Node)this.m_docTheEasyCC, key);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public Document getDocument() {
        return this.m_docTheEasyCC;
    }

    public synchronized Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheEasyCC.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_bOldHashFormat ? 1231 : 1237);
        result = 31 * result + (this.m_cascadeID == null ? 0 : this.m_cascadeID.hashCode());
        result = 31 * result + (int)(this.m_lAccountNumber ^ this.m_lAccountNumber >>> 32);
        result = 31 * result + (int)(this.m_lTransferredBytes ^ this.m_lTransferredBytes >>> 32);
        result = 31 * result + (this.m_priceCertHashesConcatenated == null ? 0 : this.m_priceCertHashesConcatenated.hashCode());
        result = 31 * result + (this.m_strPIID == null ? 0 : this.m_strPIID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLEasyCC other = (XMLEasyCC)obj;
        if (this.m_bOldHashFormat != other.m_bOldHashFormat) {
            return false;
        }
        if (this.m_cascadeID == null ? other.m_cascadeID != null : !this.m_cascadeID.equals(other.m_cascadeID)) {
            return false;
        }
        if (this.m_lAccountNumber != other.m_lAccountNumber) {
            return false;
        }
        if (this.m_lTransferredBytes != other.m_lTransferredBytes) {
            return false;
        }
        if (this.m_priceCertHashesConcatenated == null ? other.m_priceCertHashesConcatenated != null : !this.m_priceCertHashesConcatenated.equals(other.m_priceCertHashesConcatenated)) {
            return false;
        }
        return !(this.m_strPIID == null ? other.m_strPIID != null : !this.m_strPIID.equals(other.m_strPIID));
    }
}

