/*
 * Decompiled with CFR 0.152.
 */
package anon.tor;

import anon.tor.Circuit;
import anon.tor.Tor;
import anon.tor.TorChannel;
import anon.util.ByteArrayUtil;
import java.io.IOException;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;

public class TorSocksChannel
extends TorChannel {
    private static final int SOCKS_WAIT_FOR_VERSION = 0;
    private static final int SOCKS5_WAIT_FOR_METHODS = 1;
    private static final int SOCKS5_WAIT_FOR_REQUEST = 2;
    private static final int SOCKS4_WAIT_FOR_REQUEST = 3;
    private static final int DATA_MODE = 4;
    private static final int SOCKS_5 = 5;
    private static final int SOCKS_4 = 4;
    private int m_state = 0;
    private int m_version;
    private byte[] m_data = null;
    private Tor m_Tor;

    public TorSocksChannel(Tor tor) throws IOException {
        this.m_Tor = tor;
        LogHolder.log(7, LogType.TOR, "new TorSocksChannel() - object created.");
    }

    protected void send(byte[] arg0, int len) throws IOException {
        switch (this.m_state) {
            case 0: {
                this.state_WaitForVersion(arg0, len);
                break;
            }
            case 1: {
                this.state_WaitForMethods(arg0, len);
                break;
            }
            case 2: {
                this.state_WaitForRequest_Socks5(arg0, len);
                break;
            }
            case 3: {
                this.state_WaitForRequest_Socks4(arg0, len);
                break;
            }
            case 4: {
                super.send(arg0, len);
                break;
            }
            default: {
                throw new IOException("illegal status");
            }
        }
    }

    private void state_WaitForVersion(byte[] arg0, int len) throws IOException {
        if (arg0 != null && len > 0) {
            this.m_data = ByteArrayUtil.conc(this.m_data, arg0, len);
        }
        if (this.m_data.length > 1) {
            this.m_version = this.m_data[0];
            if (this.m_version != 5 && this.m_version != 4) {
                this.close();
                throw new IOException("Wrong Sock Protocol number");
            }
            this.m_data = ByteArrayUtil.copy(this.m_data, 1, this.m_data.length - 1);
            this.m_state = this.m_version == 5 ? 1 : 3;
            this.send(null, 0);
        }
    }

    private void state_WaitForMethods(byte[] arg0, int len) throws IOException {
        int nrOfMethods;
        int length;
        if (arg0 != null && len > 0) {
            this.m_data = ByteArrayUtil.conc(this.m_data, arg0, len);
        }
        if (this.m_data.length > 1 && this.m_data.length >= (length = (nrOfMethods = this.m_data[0] & 0xFF) + 1)) {
            boolean methodFound = false;
            byte[] socksAnswer = null;
            for (int i = 0; i < nrOfMethods; ++i) {
                if (this.m_data[i + 1] != 0) continue;
                methodFound = true;
                socksAnswer = new byte[]{5, 0};
                this.m_state = 2;
                break;
            }
            if (!methodFound) {
                socksAnswer = new byte[]{5, -1};
            }
            super.recv(socksAnswer, 0, socksAnswer.length);
            if (!methodFound) {
                return;
            }
            this.m_data = ByteArrayUtil.copy(this.m_data, length, this.m_data.length - length);
            if (this.m_data.length > 0) {
                this.send(null, 0);
            }
        }
    }

    private void state_WaitForRequest_Socks4(byte[] arg0, int len) throws IOException {
        if (arg0 != null && len > 0) {
            this.m_data = ByteArrayUtil.conc(this.m_data, arg0, len);
        }
        if (this.m_data.length <= 0) {
            return;
        }
        byte requestType = this.m_data[0];
        if (requestType != 1) {
            byte[] socksAnswer = new byte[]{0, 91, 0, 0, 0, 0, 0, 0};
            this.m_data = null;
            super.recv(socksAnswer, 0, socksAnswer.length);
            return;
        }
        if (this.m_data.length >= 8) {
            byte[] socksAnswer = null;
            int port = 0;
            String addr = null;
            int consumedBytes = 1;
            addr = Integer.toString(this.m_data[3] & 0xFF) + "." + Integer.toString(this.m_data[4] & 0xFF) + "." + Integer.toString(this.m_data[5] & 0xFF) + "." + Integer.toString(this.m_data[6] & 0xFF);
            port = (this.m_data[1] & 0xFF) << 8 | this.m_data[2] & 0xFF;
            consumedBytes += 6;
            int i = 7;
            while (i < this.m_data.length && this.m_data[i] != 0) {
                ++i;
                ++consumedBytes;
            }
            if (this.m_data[i] != 0) {
                return;
            }
            ++consumedBytes;
            if (addr.startsWith("0.0.0")) {
                ++i;
                StringBuffer sb = new StringBuffer();
                while (i < this.m_data.length && this.m_data[i] != 0) {
                    sb.append((char)this.m_data[i]);
                    ++i;
                    ++consumedBytes;
                }
                if (this.m_data[i] != 0) {
                    return;
                }
                ++consumedBytes;
                addr = sb.toString();
            }
            boolean connected = false;
            this.setDoNotCloseChannelOnErrorDuringConnect(true);
            Hashtable<Circuit, Circuit> excludeCircuits = new Hashtable<Circuit, Circuit>();
            for (int tries = 0; !connected && tries < 3; ++tries) {
                connected = true;
                Circuit circ = null;
                try {
                    circ = this.m_Tor.getCircuitForDestination(addr, port, excludeCircuits);
                    if (circ == null) {
                        socksAnswer = new byte[]{0, 91, 0, 0, 0, 0, 0, 0};
                        super.recv(socksAnswer, 0, socksAnswer.length);
                        this.closedByPeer();
                        return;
                    }
                    if (circ.connectChannel(this, addr, port) == 0) continue;
                    connected = false;
                    excludeCircuits.put(circ, circ);
                    continue;
                }
                catch (IOException ex) {
                    if (circ != null) {
                        excludeCircuits.put(circ, circ);
                    }
                    connected = false;
                }
            }
            if (!connected) {
                socksAnswer = new byte[]{0, 91, 0, 0, 0, 0, 0, 0};
                super.recv(socksAnswer, 0, socksAnswer.length);
                this.closedByPeer();
                return;
            }
            socksAnswer = new byte[]{0, 90, 0, 0, 0, 0, 0, 0};
            super.recv(socksAnswer, 0, socksAnswer.length);
            this.m_data = ByteArrayUtil.copy(this.m_data, consumedBytes, this.m_data.length - consumedBytes);
            this.m_state = 4;
            if (this.m_data.length > 0) {
                this.send(this.m_data, this.m_data.length);
                this.m_data = null;
            }
        }
    }

    private void state_WaitForRequest_Socks5(byte[] arg0, int len) throws IOException {
        if (arg0 != null && len > 0) {
            this.m_data = ByteArrayUtil.conc(this.m_data, arg0, len);
        }
        if (this.m_data.length > 6) {
            byte[] socksAnswer = null;
            int port = 0;
            String addr = null;
            byte requestType = this.m_data[1];
            byte addrType = this.m_data[3];
            int consumedBytes = 0;
            if (requestType != 1) {
                socksAnswer = ByteArrayUtil.conc(new byte[]{5, 7, 0}, ByteArrayUtil.copy(this.m_data, 3, this.m_data.length - 3));
                this.m_data = null;
                super.recv(socksAnswer, 0, socksAnswer.length);
                return;
            }
            switch (addrType) {
                case 1: {
                    if (this.m_data.length <= 9) break;
                    addr = Integer.toString(this.m_data[4] & 0xFF) + "." + Integer.toString(this.m_data[5] & 0xFF) + "." + Integer.toString(this.m_data[6] & 0xFF) + "." + Integer.toString(this.m_data[7] & 0xFF);
                    port = (this.m_data[8] & 0xFF) << 8 | this.m_data[9] & 0xFF;
                    consumedBytes = 10;
                    break;
                }
                case 3: {
                    int length = this.m_data[4] & 0xFF;
                    if (this.m_data.length < 7 + length) break;
                    addr = new String(this.m_data, 5, length);
                    port = (this.m_data[5 + length] & 0xFF) << 8 | this.m_data[6 + length] & 0xFF;
                    consumedBytes = length + 7;
                    break;
                }
                default: {
                    socksAnswer = ByteArrayUtil.conc(new byte[]{5, 8, 0}, ByteArrayUtil.copy(this.m_data, 3, this.m_data.length - 3));
                    super.recv(socksAnswer, 0, socksAnswer.length);
                    this.m_data = null;
                }
            }
            if (addr != null) {
                Circuit circ;
                Hashtable<Circuit, Circuit> excludeCircuits = new Hashtable<Circuit, Circuit>();
                boolean bChannelCreated = false;
                this.setDoNotCloseChannelOnErrorDuringConnect(true);
                for (int tries = 0; tries < 3 && (circ = this.m_Tor.getCircuitForDestination(addr, port, excludeCircuits)) != null; ++tries) {
                    if (circ.connectChannel(this, addr, port) == 0) {
                        bChannelCreated = true;
                        break;
                    }
                    excludeCircuits.put(circ, circ);
                }
                if (!bChannelCreated) {
                    socksAnswer = ByteArrayUtil.conc(new byte[]{5, 1, 0}, ByteArrayUtil.copy(this.m_data, 3, consumedBytes - 3));
                    super.recv(socksAnswer, 0, socksAnswer.length);
                    this.closedByPeer();
                    return;
                }
                socksAnswer = ByteArrayUtil.conc(new byte[]{5, 0, 0}, ByteArrayUtil.copy(this.m_data, 3, consumedBytes - 3));
                super.recv(socksAnswer, 0, socksAnswer.length);
                this.m_data = ByteArrayUtil.copy(this.m_data, consumedBytes, this.m_data.length - consumedBytes);
                this.m_state = 4;
                if (this.m_data.length > 0) {
                    this.send(this.m_data, this.m_data.length);
                    this.m_data = null;
                }
            }
        }
    }
}

