/*
 * Decompiled with CFR 0.152.
 */
package anon.tor.ordescription;

import anon.crypto.MyRSAPublicKey;
import anon.crypto.MyRSASignature;
import anon.tor.ordescription.ORAcl;
import anon.tor.util.Base16;
import anon.util.Base64;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class ORDescriptor {
    private String m_address;
    private String m_name;
    private String m_fingerprint;
    private boolean m_hibernate;
    private int m_port;
    private int m_portDir;
    private int m_uptime;
    private String m_strSoftware;
    private String m_published;
    private String m_hash;
    private ORAcl m_acl;
    private boolean m_bIsExitNode;
    private MyRSAPublicKey m_onionkey;
    private MyRSAPublicKey m_signingkey;
    private Vector family;

    public ORDescriptor(String address, String name, int port, String strSoftware) {
        this.m_address = address;
        this.m_name = name;
        this.m_port = port;
        this.m_portDir = -1;
        this.m_strSoftware = strSoftware;
        this.m_acl = new ORAcl();
        this.m_bIsExitNode = false;
        this.m_uptime = 0;
        this.m_hibernate = false;
        this.family = null;
    }

    public void setPublished(String published) {
        this.m_published = published;
    }

    public String getPublished() {
        return this.m_published;
    }

    public void setFingerprint(String fp) {
        this.m_fingerprint = fp;
    }

    public String getFingerprint() {
        return this.m_fingerprint;
    }

    public void setHash(String hash2) {
        this.m_hash = hash2;
    }

    public String getHash() {
        return this.m_hash;
    }

    public void setUptime(int uptime) {
        this.m_uptime = uptime;
    }

    public int getUptime() {
        return this.m_uptime;
    }

    public Vector getFamily() {
        return this.family;
    }

    public void setHibernate(boolean hibernate) {
        this.m_hibernate = hibernate;
    }

    public boolean getHibernate() {
        return this.m_hibernate;
    }

    public void setExitNode(boolean bIsExitNode) {
        this.m_bIsExitNode = bIsExitNode;
    }

    public void setFamily(Vector fam) {
        this.family = fam;
    }

    public boolean isExitNode() {
        return this.m_bIsExitNode;
    }

    public void setAcl(ORAcl acl) {
        this.m_acl = acl;
    }

    public ORAcl getAcl() {
        return this.m_acl;
    }

    public boolean setOnionKey(byte[] onionkey) {
        this.m_onionkey = MyRSAPublicKey.getInstance(onionkey);
        return this.m_onionkey != null;
    }

    public MyRSAPublicKey getOnionKey() {
        return this.m_onionkey;
    }

    public boolean setSigningKey(byte[] signingkey) {
        this.m_signingkey = MyRSAPublicKey.getInstance(signingkey);
        return this.m_signingkey != null;
    }

    public MyRSAPublicKey getSigningKey() {
        return this.m_signingkey;
    }

    public String getAddress() {
        return this.m_address;
    }

    public String getName() {
        return this.m_name;
    }

    public void setDirPort(int port) {
        this.m_portDir = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public int getDirPort() {
        return this.m_portDir;
    }

    public String getSoftware() {
        return this.m_strSoftware;
    }

    public boolean isSimilar(Object onionrouter) {
        if (onionrouter != null && onionrouter instanceof ORDescriptor) {
            ORDescriptor or = (ORDescriptor)onionrouter;
            if (this.m_address.equals(or.getAddress()) && this.m_name.equals(or.getName()) && this.m_port == or.getPort()) {
                return true;
            }
            if (or.family != null && this.family != null && or.family.contains(this.m_name) && this.family.contains(or.getName())) {
                return true;
            }
        }
        return false;
    }

    public static ORDescriptor parse(LineNumberReader reader) {
        try {
            StringBuffer buff;
            StringBuffer router_doc = new StringBuffer();
            String ln = reader.readLine();
            router_doc.append(ln);
            router_doc.append("\n");
            boolean bIsExitNode = false;
            if (ln == null || !ln.startsWith("router")) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(ln);
            st.nextToken();
            String nickname = st.nextToken();
            String adr = st.nextToken();
            String orport = st.nextToken();
            String socksport = st.nextToken();
            String dirport = st.nextToken();
            Vector<String> fam = null;
            byte[] key = null;
            byte[] signingkey = null;
            ORAcl acl = new ORAcl();
            String strSoftware = "";
            String published = "";
            String fp = "";
            boolean hibernate = false;
            block6: while (true) {
                if ((ln = reader.readLine()) == null) {
                    return null;
                }
                router_doc.append(ln);
                router_doc.append("\n");
                if (ln == null) {
                    return null;
                }
                if (ln.startsWith("opt ")) {
                    ln = ln.substring(4);
                }
                if (ln.startsWith("platform")) {
                    strSoftware = ln.substring(9);
                    continue;
                }
                if (ln.startsWith("published")) {
                    published = ln.substring(10);
                    continue;
                }
                if (ln.startsWith("accept")) {
                    acl.add(ln);
                    bIsExitNode = true;
                    continue;
                }
                if (ln.startsWith("reject")) {
                    acl.add(ln);
                    continue;
                }
                if (ln.startsWith("fingerprint")) {
                    buff = new StringBuffer();
                    st = new StringTokenizer(ln);
                    st.nextToken();
                    while (st.hasMoreTokens()) {
                        buff.append(st.nextToken());
                    }
                    fp = buff.toString();
                    continue;
                }
                if (ln.startsWith("hibernate")) {
                    try {
                        if (Integer.parseInt(ln.substring(10)) == 1) {
                            hibernate = true;
                            continue;
                        }
                        hibernate = false;
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (ln.startsWith("onion-key")) {
                    buff = new StringBuffer();
                    ln = reader.readLine();
                    if (ln == null) {
                        return null;
                    }
                    router_doc.append(ln);
                    router_doc.append("\n");
                    while (true) {
                        if ((ln = reader.readLine()) == null) {
                            return null;
                        }
                        router_doc.append(ln);
                        router_doc.append("\n");
                        if (ln.startsWith("-----END")) {
                            key = Base64.decode(buff.toString());
                            continue block6;
                        }
                        buff.append(ln);
                    }
                }
                if (ln.startsWith("signing-key")) {
                    buff = new StringBuffer();
                    ln = reader.readLine();
                    if (ln == null) {
                        return null;
                    }
                    router_doc.append(ln);
                    router_doc.append("\n");
                    while (true) {
                        if ((ln = reader.readLine()) == null) {
                            return null;
                        }
                        router_doc.append(ln);
                        router_doc.append("\n");
                        if (ln.startsWith("-----END")) {
                            signingkey = Base64.decode(buff.toString());
                            continue block6;
                        }
                        buff.append(ln);
                    }
                }
                if (ln.startsWith("family")) {
                    st = new StringTokenizer(ln);
                    st.nextToken();
                    fam = new Vector<String>();
                    while (true) {
                        if (!st.hasMoreTokens()) continue block6;
                        fam.addElement(st.nextToken());
                    }
                }
                if (ln.startsWith("router-signature")) break;
            }
            buff = new StringBuffer();
            ln = reader.readLine();
            if (ln == null) {
                return null;
            }
            while (true) {
                if ((ln = reader.readLine()) == null) {
                    return null;
                }
                if (ln.startsWith("-----END")) {
                    ORDescriptor ord = new ORDescriptor(adr, nickname, Integer.parseInt(orport), strSoftware);
                    if (!ord.setOnionKey(key) || !ord.setSigningKey(signingkey)) {
                        return null;
                    }
                    ord.setAcl(acl);
                    ord.setExitNode(bIsExitNode);
                    ord.setFamily(fam);
                    ord.setPublished(published);
                    ord.setFingerprint(fp);
                    ord.setHibernate(hibernate);
                    ord.setHash(ORDescriptor.calcHash(router_doc.toString()));
                    try {
                        ord.setDirPort(Integer.parseInt(dirport));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return ord;
                }
                buff.append(ln);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "ORRouter: " + this.m_name + " on " + this.m_address + ":" + this.m_port + " Software : " + this.m_strSoftware + " isExitNode:" + this.m_bIsExitNode;
    }

    private static String calcHash(String desc) {
        SHA1Digest dig = new SHA1Digest();
        byte[] in = desc.getBytes();
        byte[] out = new byte[dig.getDigestSize()];
        dig.update(in, 0, in.length);
        dig.doFinal(out, 0);
        return Base16.encode(out);
    }

    private static boolean checkSignature(byte[] document, byte[] signature, byte[] identity) {
        try {
            MyRSAPublicKey key = MyRSAPublicKey.getInstance(identity);
            MyRSASignature sign = new MyRSASignature();
            sign.initVerify(key);
            return sign.verify(document, signature);
        }
        catch (Throwable t) {
            return false;
        }
    }
}

