/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import anon.util.IMiscPasswordReader;
import anon.util.JAPMessages;
import anon.util.Util;
import gui.GUIUtils;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class PasswordContentPane
extends DialogContentPane
implements IMiscPasswordReader,
DialogContentPane.IWizardSuitable {
    public static final int PASSWORD_NEW = 1;
    public static final int PASSWORD_ENTER = 2;
    public static final int PASSWORD_CHANGE = 3;
    public static final int NO_MINIMUM_LENGTH = 0;
    public static final String MSG_ENTER_LBL = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_enterPasswordLabel";
    private static final int FIELD_LENGTH = 15;
    private static final String MSG_TOO_SHORT = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_tooShort";
    private static final String MSG_CAPS_LOCK_PRESSED = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_pressedCapsLock";
    private static final String MSG_WRONG_PASSWORD = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_wrongPassword";
    public static final String MSG_ENTER_PASSWORD_TITLE = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_title";
    private static final String MSG_CONFIRM_LBL = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_confirmPasswordLabel";
    private static final String MSG_ENTER_OLD_LBL = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_enterOldPasswordLabel";
    private static final String MSG_ENTER_NEW_LBL = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_enterNewPasswordLabel";
    private static final String MSG_PASSWORDS_DONT_MATCH = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_passwordsDontMatch";
    private static final String MSG_INSERT_FROM_CLIP = (class$gui$dialog$PasswordContentPane == null ? (class$gui$dialog$PasswordContentPane = PasswordContentPane.class$("gui.dialog.PasswordContentPane")) : class$gui$dialog$PasswordContentPane).getName() + "_insertFromClipboard";
    private JPasswordField m_textOldPasswd;
    private JPasswordField m_textNewPasswd;
    private JPasswordField m_textConfirmPasswd;
    private char[] m_passwd = null;
    private char[] m_oldPasswd = null;
    private int m_type;
    private int m_minLength;
    private JLabel m_lblNew1;
    private JLabel m_lblNew2;
    private JLabel m_lblOld;
    private JPopupMenu m_popup = new JPopupMenu();
    private JPasswordField m_currentPopup;
    static /* synthetic */ Class class$gui$dialog$PasswordContentPane;
    static /* synthetic */ Class class$java$awt$Toolkit;

    public PasswordContentPane(JAPDialog a_parentDialog, int a_type, String a_strMessage, int a_minLength) {
        this(a_parentDialog, null, a_type, a_strMessage, a_minLength);
    }

    public PasswordContentPane(JAPDialog a_parentDialog, int a_type, String a_strMessage) {
        this(a_parentDialog, null, a_type, a_strMessage, 0);
    }

    public PasswordContentPane(JAPDialog a_parentDialog, DialogContentPane a_previousContentPane, int a_type, String a_strMessage) {
        this(a_parentDialog, a_previousContentPane, a_type, a_strMessage, 0);
    }

    public PasswordContentPane(JAPDialog a_parentDialog, DialogContentPane a_previousContentPane, int a_type, String a_strMessage, int a_minLength) {
        super(a_parentDialog, a_strMessage != null ? a_strMessage : "", new DialogContentPane.Layout(JAPMessages.getString(MSG_ENTER_PASSWORD_TITLE), 3), new DialogContentPaneOptions(2, a_previousContentPane));
        this.setDefaultButtonOperation(266);
        if (a_type < 1 || a_type > 3) {
            throw new IllegalArgumentException("Unknown type!");
        }
        this.m_type = a_type;
        if (a_minLength < 0) {
            a_minLength = 0;
        }
        this.m_minLength = a_minLength;
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JMenuItem itemInsertPassword = new JMenuItem(JAPMessages.getString(MSG_INSERT_FROM_CLIP));
        MouseAdapter popupListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent a_event) {
                if (GUIUtils.isMouseButton(a_event, 8) || GUIUtils.isMouseButton(a_event, 4)) {
                    PasswordContentPane.this.m_currentPopup = (JPasswordField)a_event.getComponent();
                    PasswordContentPane.this.m_popup.show(a_event.getComponent(), a_event.getX(), a_event.getY());
                }
            }
        };
        this.getContentPane().setLayout(layout);
        c.anchor = 17;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.m_popup = new JPopupMenu();
        itemInsertPassword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                Clipboard clip = GUIUtils.getSystemClipboard();
                Transferable data = clip.getContents(this);
                if (data != null && data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        ((JTextComponent)PasswordContentPane.this.m_currentPopup).setText((String)data.getTransferData(DataFlavor.stringFlavor));
                    }
                    catch (Exception a_e) {
                        // empty catch block
                    }
                }
            }
        });
        this.m_popup.add(itemInsertPassword);
        if (a_type == 3) {
            this.m_lblOld = new JLabel(this.getOldPasswordLabel());
            layout.setConstraints(this.m_lblOld, c);
            this.getContentPane().add(this.m_lblOld);
            this.m_textOldPasswd = new JPasswordField(15);
            this.m_textOldPasswd.setEchoChar('*');
            this.m_textOldPasswd.addMouseListener(popupListener);
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            layout.setConstraints(this.m_textOldPasswd, c);
            this.getContentPane().add(this.m_textOldPasswd);
        }
        if (a_type == 3 || a_type == 1) {
            this.m_lblNew1 = new JLabel(this.getNewPasswordLabel());
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 0;
            this.getContentPane().add((Component)this.m_lblNew1, c);
            this.m_textNewPasswd = new JPasswordField(15);
            this.m_textNewPasswd.setEchoChar('*');
            this.m_textNewPasswd.addMouseListener(popupListener);
            c.fill = 2;
            c.gridx = 1;
            c.weightx = 1.0;
            layout.setConstraints(this.m_textNewPasswd, c);
            this.getContentPane().add(this.m_textNewPasswd);
        }
        this.m_lblNew2 = a_type == 2 ? new JLabel(JAPMessages.getString(MSG_ENTER_LBL)) : new JLabel(JAPMessages.getString(MSG_CONFIRM_LBL));
        c.fill = 0;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.getContentPane().add((Component)this.m_lblNew2, c);
        this.m_textConfirmPasswd = new JPasswordField(15);
        this.m_textConfirmPasswd.setEchoChar('*');
        this.m_textConfirmPasswd.addMouseListener(popupListener);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        layout.setConstraints(this.m_textConfirmPasswd, c);
        this.getContentPane().add(this.m_textConfirmPasswd);
        CapsLockAdapter keyAdapter = new CapsLockAdapter();
        this.m_textConfirmPasswd.addKeyListener(keyAdapter);
        if (this.m_textNewPasswd != null) {
            this.m_textNewPasswd.addKeyListener(keyAdapter);
        }
        if (this.m_textOldPasswd != null) {
            this.m_textOldPasswd.addKeyListener(keyAdapter);
        }
        this.addComponentListener(new SetFocusComponentAdapter());
    }

    public String readPassword(Object a_message) {
        DialogContentPane.CheckError errors = this.updateDialog();
        if (errors != null) {
            return null;
        }
        this.setButtonValue(-1);
        this.showDialog();
        if (a_message != null) {
            this.printStatusMessage(a_message.toString());
        }
        if (this.getButtonValue() != 0 || this.getPassword() == null) {
            return null;
        }
        return new String(this.getPassword());
    }

    public char[] getPassword() {
        if (this.getButtonValue() != 0) {
            return null;
        }
        if (this.m_passwd == null) {
            return new char[]{'\u0000'};
        }
        return this.m_passwd;
    }

    public boolean isAutomaticFocusSettingEnabled() {
        return false;
    }

    public String getNewPasswordLabel() {
        return JAPMessages.getString(MSG_ENTER_NEW_LBL);
    }

    public String getOldPasswordLabel() {
        return JAPMessages.getString(MSG_ENTER_OLD_LBL);
    }

    public char[] getOldPassword() {
        if (!this.hasValidValue()) {
            return null;
        }
        if (this.m_oldPasswd == null) {
            return new char[]{'\u0000'};
        }
        return this.m_oldPasswd;
    }

    public char[] getComparedPassword() {
        return null;
    }

    public DialogContentPane.CheckError checkYesOK() {
        DialogContentPane.CheckError errors = null;
        if (this.m_type == 1 || this.m_type == 3) {
            if (this.m_minLength > 0 && (this.m_textNewPasswd.getPassword() == null || this.m_textNewPasswd.getPassword().length < this.m_minLength)) {
                errors = new DialogContentPane.CheckError(JAPMessages.getString(MSG_TOO_SHORT, new Integer(this.m_minLength))){

                    public void doErrorAction() {
                        PasswordContentPane.this.m_lblNew1.setForeground(Color.red);
                    }

                    public void undoErrorAction() {
                        PasswordContentPane.this.m_lblNew1.setForeground(new JLabel().getForeground());
                    }
                };
            }
            if (!Util.arraysEqual(this.m_textConfirmPasswd.getPassword(), this.m_textNewPasswd.getPassword())) {
                errors = new DialogContentPane.CheckError(JAPMessages.getString(MSG_PASSWORDS_DONT_MATCH)){

                    public void doErrorAction() {
                        PasswordContentPane.this.m_lblNew1.setForeground(Color.red);
                        PasswordContentPane.this.m_lblNew2.setForeground(Color.red);
                    }

                    public void undoErrorAction() {
                        PasswordContentPane.this.m_lblNew1.setForeground(new JLabel().getForeground());
                        PasswordContentPane.this.m_lblNew2.setForeground(new JLabel().getForeground());
                    }
                };
            } else {
                this.m_passwd = this.m_textNewPasswd.getPassword();
            }
        } else if (this.m_type == 2) {
            this.m_passwd = this.m_textConfirmPasswd.getPassword();
        }
        if (this.m_type == 3) {
            if (this.getComparedPassword() != null && !Util.arraysEqual(this.getComparedPassword(), this.m_textOldPasswd.getPassword())) {
                errors = new DialogContentPane.CheckError(JAPMessages.getString(MSG_WRONG_PASSWORD)){

                    public void doErrorAction() {
                        PasswordContentPane.this.m_lblOld.setForeground(Color.red);
                    }

                    public void undoErrorAction() {
                        PasswordContentPane.this.m_lblOld.setForeground(new JLabel().getForeground());
                    }
                };
            } else {
                this.m_oldPasswd = this.m_textOldPasswd.getPassword();
            }
        }
        return errors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SetFocusComponentAdapter
    extends ComponentAdapter {
        private SetFocusComponentAdapter() {
        }

        public void componentShown(ComponentEvent a_event) {
            if (PasswordContentPane.this.m_type == 3) {
                PasswordContentPane.this.m_textOldPasswd.requestFocus();
            } else if (PasswordContentPane.this.m_type == 1) {
                PasswordContentPane.this.m_textNewPasswd.requestFocus();
            } else {
                PasswordContentPane.this.m_textConfirmPasswd.requestDefaultFocus();
            }
        }
    }

    private class CapsLockAdapter
    extends KeyAdapter {
        private int m_messageID = 0;

        private CapsLockAdapter() {
        }

        public void keyPressed(KeyEvent a_event) {
            boolean isCapsLockPressed = false;
            try {
                isCapsLockPressed = (Boolean)(class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = PasswordContentPane.class$("java.awt.Toolkit")) : class$java$awt$Toolkit).getMethod("getLockingKeyState", Integer.TYPE).invoke((Object)PasswordContentPane.this.getContentPane().getToolkit(), new Integer(20));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isCapsLockPressed) {
                this.m_messageID = PasswordContentPane.this.printErrorStatusMessage(JAPMessages.getString(MSG_CAPS_LOCK_PRESSED));
            } else {
                PasswordContentPane.this.clearStatusMessage(this.m_messageID);
            }
        }
    }
}

