/*
 * Decompiled with CFR 0.152.
 */
package logging;

import java.io.File;
import java.io.IOException;
import logging.AbstractLog4jLog;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public final class FileLog
extends AbstractLog4jLog {
    RollingFileAppender m_appender;

    public FileLog(File fileName, int maxFileSize, int maxBackups) throws IOException {
        this(fileName.getAbsolutePath(), maxFileSize, maxBackups);
    }

    public FileLog(String fileName, int maxFileSize, int maxBackups) throws IOException {
        PatternLayout layout = new PatternLayout("[%d{ISO8601} - %p] %m%n");
        this.m_appender = new RollingFileAppender(layout, fileName, true);
        this.m_appender.setMaximumFileSize(maxFileSize);
        this.m_appender.setMaxBackupIndex(maxBackups);
        this.m_appender.setBufferedIO(false);
        this.m_appender.activateOptions();
        this.getLogger().removeAllAppenders();
        this.getLogger().addAppender(this.m_appender);
    }

    public String getFile() {
        return this.m_appender.getFile();
    }

    protected Logger getLogger() {
        return Logger.getRootLogger();
    }
}

