/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.infoservice;

import anon.infoservice.ListenerInterface;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class InfoServiceData
implements IXMLEncodable,
Cloneable {
    private ListenerInterface[] m_interfaces;
    private String m_strXMLNodeName;

    public InfoServiceData(String strXMLNodeName) {
        this.m_strXMLNodeName = strXMLNodeName;
        this.m_interfaces = new ListenerInterface[0];
    }

    public InfoServiceData(String strXMLNodeName, ListenerInterface[] list) {
        this.m_strXMLNodeName = strXMLNodeName;
        this.m_interfaces = list;
    }

    public InfoServiceData(String strXMLNodeName, String host, int port) {
        this.m_strXMLNodeName = strXMLNodeName;
        this.m_interfaces = new ListenerInterface[0];
        ListenerInterface iface = new ListenerInterface(host, port, 1);
        this.addListenerInterface(iface);
    }

    public int getNumberOfListeners() {
        return this.m_interfaces.length;
    }

    public void addListenerInterface(ListenerInterface iface) {
        ListenerInterface[] nList = new ListenerInterface[this.m_interfaces.length + 1];
        for (int i = 0; i < this.m_interfaces.length; ++i) {
            nList[i] = this.m_interfaces[i];
        }
        nList[this.m_interfaces.length] = iface;
        this.m_interfaces = nList;
    }

    public void removeListenerInterface(int index) {
        if (index >= 0 && index < this.m_interfaces.length) {
            int i;
            ListenerInterface[] ifaces = new ListenerInterface[this.m_interfaces.length - 1];
            for (i = 0; i < index; ++i) {
                ifaces[i] = this.m_interfaces[i];
            }
            for (i = index + 1; i < this.m_interfaces.length; ++i) {
                ifaces[i - 1] = this.m_interfaces[i];
            }
            this.m_interfaces = ifaces;
        }
    }

    public ListenerInterface getListenerInterface(int index) {
        if (index < 0 || index >= this.m_interfaces.length) {
            return null;
        }
        return this.m_interfaces[index];
    }

    public Vector getListenerInterfaces() {
        Vector<ListenerInterface> listenerInterfaces = new Vector<ListenerInterface>();
        ListenerInterface[] listeners = this.m_interfaces;
        for (int i = 0; i < listeners.length; ++i) {
            listenerInterfaces.addElement(listeners[i]);
        }
        return listenerInterfaces;
    }

    @Override
    public Element toXmlElement(Document doc) {
        Element infoServiceRoot = doc.createElement(this.m_strXMLNodeName);
        Element ifacesRoot = doc.createElement("ListenerInterfaces");
        infoServiceRoot.appendChild(ifacesRoot);
        for (int i = 0; i < this.m_interfaces.length; ++i) {
            LogHolder.log(7, LogType.MISC, "Appending " + this.m_interfaces[i]);
            ifacesRoot.appendChild(this.m_interfaces[i].toXmlElement(doc));
        }
        return infoServiceRoot;
    }

    public static InfoServiceData createFromElement(String tag, Element elemRoot) throws XMLParseException {
        if (elemRoot.getTagName().equals(tag)) {
            Node child;
            for (child = elemRoot.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
            }
            if (child.getNodeName().equals("ListenerInterfaces")) {
                ListenerInterface[] ifaceList = new ListenerInterface[]{};
                for (child = child.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 1) continue;
                    ListenerInterface iface = new ListenerInterface((Element)child);
                    LogHolder.log(7, LogType.NET, "Found InfoService --> " + iface.getHost() + ":" + iface.getPort());
                    ListenerInterface[] nList = new ListenerInterface[ifaceList.length + 1];
                    for (int i = 0; i < ifaceList.length; ++i) {
                        nList[i] = ifaceList[i];
                    }
                    nList[ifaceList.length] = iface;
                    ifaceList = nList;
                }
                return new InfoServiceData(tag, ifaceList);
            }
            LogHolder.log(4, LogType.NET, "Could not find 'ListenerInterfaces'!");
            return new InfoServiceData(tag);
        }
        throw new XMLParseException(tag, "This is not the right element: " + elemRoot + " vs. " + tag);
    }
}

