/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.pay.xml.XMLPriceCertificate;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import logging.LogHolder;
import logging.LogType;
import mixconfig.ConfigurationEvent;
import mixconfig.MixConfig;

public class PriceCertPanel
extends JPanel
implements ActionListener,
ChangeListener {
    public static final String XMLPATH_PRICECERT = "Accounting/PriceCertificate";
    private static final String MSG_CHOOSE_IMPORT_METHOD = PriceCertPanel.class.getName() + "_chooseImportMethod";
    private static final String MSG_CONFIRM_DELETION = PriceCertPanel.class.getName() + "_confirmDeletion";
    private XMLPriceCertificate m_cert;
    private Vector<ChangeListener> m_changeListeners = new Vector();
    private JButton m_bttnImport;
    private JButton m_bttnUpdate;
    private JButton m_bttnRemove;
    private JLabel m_rate;

    public PriceCertPanel(String name, String toolTip, XMLPriceCertificate priceCert) {
        this.m_cert = priceCert;
        MixConfig.getMixConfiguration().addChangeListener(this);
        this.setBorder(new TitledBorder(name));
        this.setToolTipText(toolTip);
        this.m_bttnImport = new JButton("Import");
        this.m_bttnImport.addActionListener(this);
        this.m_bttnUpdate = new JButton("Update");
        this.m_bttnUpdate.addActionListener(this);
        this.m_bttnRemove = new JButton("Remove");
        this.m_bttnRemove.addActionListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        this.add((Component)this.m_bttnImport, constraints);
        ++constraints.gridx;
        this.add((Component)this.m_bttnUpdate, constraints);
        ++constraints.gridx;
        this.add((Component)this.m_bttnRemove, constraints);
        constraints.anchor = 10;
        constraints.gridx = 1;
        constraints.gridy = 1;
        this.add((Component)new JLabel(), constraints);
        JLabel rateLabel = new JLabel("Price per MB: ");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        this.add((Component)rateLabel, constraints);
        this.m_rate = new JLabel("");
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        this.add((Component)this.m_rate, constraints);
        constraints.fill = 1;
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        this.add((Component)new JLabel(), constraints);
        this.showPrice(this.m_cert);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent a_e) {
        if (a_e.getSource() == this.m_bttnImport) {
            try {
                if (this.importCert()) {
                    LogHolder.log(6, LogType.PAY, "Successfully imported price certificate");
                    this.fireStateChanged();
                }
            }
            catch (IOException ioe) {
                LogHolder.log(3, LogType.PAY, "Error while importing certificate: " + ioe.getMessage());
            }
        } else if (a_e.getSource() == this.m_bttnUpdate) {
            LogHolder.log(7, LogType.PAY, "TODO: Show a PriceCertDialog, update the certificate!");
        } else if (a_e.getSource() == this.m_bttnRemove && JAPDialog.showConfirmDialog((Component)this, JAPMessages.getString(MSG_CONFIRM_DELETION), 2, 3) == 0) {
            this.removeCert();
        }
        this.enableButtons();
    }

    private boolean importCert() throws IOException {
        byte[] cert = null;
        JAPDialog dialog = new JAPDialog(this, "Import Price Certificate");
        ChooseImportMethodPane pane = new ChooseImportMethodPane(dialog, JAPMessages.getString(MSG_CHOOSE_IMPORT_METHOD));
        pane.updateDialog();
        dialog.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        if (pane.getButtonValue() != 0) {
            return false;
        }
        if (pane.isMethodFile()) {
            cert = MixConfig.openFile(this, 2);
            if (cert == null) {
                return false;
            }
        } else {
            cert = GUIUtils.getTextFromClipboard(this).getBytes();
        }
        this.setCert(cert);
        return this.m_cert != null;
    }

    public void removeCert() {
        this.m_cert = null;
        this.clearPrice();
        this.fireStateChanged();
    }

    public XMLPriceCertificate getCert() {
        return this.m_cert;
    }

    public void setCert(byte[] a_cert) {
        try {
            this.m_cert = new XMLPriceCertificate(a_cert);
            this.showPrice(this.m_cert);
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.PAY, "Error while importing price certificate: " + e.getMessage());
        }
    }

    public void setCert(XMLPriceCertificate a_cert) {
        this.m_cert = a_cert;
        this.showPrice(this.m_cert);
    }

    private void showPrice(XMLPriceCertificate a_cert) {
        if (a_cert == null) {
            this.clearPrice();
        } else {
            String rateText = this.formatEuroCentValue(a_cert.getRate());
            this.m_rate.setForeground(Color.BLACK);
            this.m_rate.setText(rateText);
            this.m_rate.setToolTipText("Price per Megabyte");
        }
    }

    private String formatEuroCentValue(double centvalue) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf.format(centvalue) + " Eurocent";
    }

    private void clearPrice() {
        this.m_rate.setForeground(Color.RED);
        this.m_rate.setText("No Certificate!");
        this.m_rate.setToolTipText("No price certificate available");
    }

    private void showError(String sMessage, String sToolTip) {
        this.m_rate.setForeground(Color.RED);
        this.m_rate.setText(sMessage);
        this.m_rate.setToolTipText(sToolTip);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JButton) continue;
            components[i].setEnabled(enabled);
        }
        if (this.getBorder() instanceof TitledBorder) {
            TitledBorder border = new TitledBorder(((TitledBorder)this.getBorder()).getTitle());
            if (!enabled) {
                border.setTitleColor(Color.gray);
            }
            this.setBorder(border);
        }
        super.setEnabled(enabled);
        this.enableButtons();
    }

    private void enableButtons() {
        boolean cert = this.m_cert != null;
        boolean enabled = this.isEnabled();
        if (this.m_bttnImport != null) {
            this.m_bttnImport.setEnabled(enabled);
        }
        if (this.m_bttnUpdate != null) {
            this.m_bttnUpdate.setEnabled(false);
        }
        if (this.m_bttnRemove != null) {
            this.m_bttnRemove.setEnabled(enabled && cert);
        }
    }

    private void checkIDs() {
        String sMixID = MixConfig.getMixConfiguration().getValue("General/MixID");
        String sPaymentInstanceID = MixConfig.getMixConfiguration().getAttributeValue("Accounting/PaymentInstance", "id");
        boolean bMixIDFits = true;
        boolean bPIIDFits = true;
        String sError = "";
        String sErrorToolTip = "";
        if (sMixID != null) {
            if (this.m_cert.getSubjectKeyIdentifier().equals(sMixID)) {
                LogHolder.log(7, LogType.MISC, "Successfully checked MixID vs. price certificate");
            } else {
                bMixIDFits = false;
                LogHolder.log(3, LogType.MISC, "The MixID does not fit the SKI of the price certificate!");
                sError = sError + "Incompatible Mix-Cert";
                sErrorToolTip = sErrorToolTip + "The MixID does not fit the SubjectKeyIdentifier of this price certificate";
            }
        }
        if (sPaymentInstanceID != null) {
            if (this.m_cert.getBiID().equals(sPaymentInstanceID)) {
                LogHolder.log(7, LogType.MISC, "Successfully checked PI-ID vs. price certificate");
            } else {
                System.out.println(this.m_cert.getBiID());
                System.out.println(sPaymentInstanceID);
                bPIIDFits = false;
                LogHolder.log(3, LogType.MISC, "The ID of the PI does not fit the PI-ID in the price certificate!");
                if (!bMixIDFits) {
                    sError = "Incompatible Mix- and JPI-Cert";
                    sErrorToolTip = sErrorToolTip + "<br/> AND <br/>";
                } else {
                    sError = sError + "Incompatible JPI-Cert";
                    sErrorToolTip = sErrorToolTip + "The ID of the JPI does not fit the PI-ID in the price certificate";
                }
            }
        }
        if (bMixIDFits && bPIIDFits) {
            this.showPrice(this.m_cert);
        } else {
            this.showError(sError, sErrorToolTip + "!");
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        ConfigurationEvent configEvent;
        String sPath;
        if (this.m_cert != null && event instanceof ConfigurationEvent && ((sPath = (configEvent = (ConfigurationEvent)event).getModifiedXMLPath()).equals(XMLPATH_PRICECERT) || sPath.equals("General/MixID") || sPath.equals("Accounting/PaymentInstance"))) {
            this.checkIDs();
        }
    }

    public void addChangeListener(ChangeListener a_listener) {
        this.m_changeListeners.addElement(a_listener);
    }

    private void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < this.m_changeListeners.size(); ++i) {
            this.m_changeListeners.elementAt(i).stateChanged(event);
        }
    }

    private class ChooseImportMethodPane
    extends DialogContentPane
    implements DialogContentPane.IWizardSuitable {
        private JRadioButton m_btnFile;
        private JRadioButton m_btnClip;

        public ChooseImportMethodPane(JAPDialog a_dialog, String a_strText) {
            super(a_dialog, a_strText, new DialogContentPaneOptions(2));
            GridBagConstraints constr = new GridBagConstraints();
            ButtonGroup group = new ButtonGroup();
            this.m_btnFile = new JRadioButton("File");
            this.m_btnClip = new JRadioButton("Clipboard");
            group.add(this.m_btnFile);
            group.add(this.m_btnClip);
            this.m_btnFile.setSelected(true);
            constr.gridx = 0;
            constr.gridy = 0;
            constr.anchor = 17;
            constr.fill = 2;
            constr.weightx = 0.0;
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)this.m_btnFile, constr);
            ++constr.gridy;
            this.getContentPane().add((Component)this.m_btnClip, constr);
        }

        public boolean isMethodFile() {
            return this.m_btnFile.isSelected();
        }
    }
}

