/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.awk;

import java.util.BitSet;
import org.apache.oro.text.awk.LeafNode;
import org.apache.oro.text.awk.SyntaxNode;

final class SyntaxTree {
    int _positions;
    SyntaxNode _root;
    LeafNode[] _nodes;
    BitSet[] _followSet;

    SyntaxTree(SyntaxNode root, int positions) {
        this._root = root;
        this._positions = positions;
    }

    void _computeFollowPositions() {
        this._followSet = new BitSet[this._positions];
        this._nodes = new LeafNode[this._positions];
        int index = this._positions;
        while (0 < index--) {
            this._followSet[index] = new BitSet(this._positions);
        }
        this._root._followPosition(this._followSet, this._nodes);
    }

    private void __addToFastMap(BitSet pos, boolean[] fastMap, boolean[] done) {
        int node = 0;
        while (node < this._positions) {
            if (pos.get(node) && !done[node]) {
                done[node] = true;
                int token = 0;
                while (token < 256) {
                    if (!fastMap[token]) {
                        fastMap[token] = this._nodes[node]._matches((char)token);
                    }
                    ++token;
                }
            }
            ++node;
        }
    }

    boolean[] createFastMap() {
        boolean[] fastMap = new boolean[256];
        boolean[] done = new boolean[this._positions];
        this.__addToFastMap(this._root._firstPosition(), fastMap, done);
        return fastMap;
    }
}

