/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.Cookie2;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.DefaultCookiePolicyHandler;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ProtocolException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CookieModule
implements HTTPClientModule,
GlobalConstants {
    private static Hashtable cookie_cntxt_list;
    private static File cookie_jar;
    private static CookiePolicyHandler cookie_handler;

    static void classFinalize() {
        if (cookie_jar != null && cookie_jar.isFile() && cookie_jar.canWrite()) {
            Hashtable<Cookie, Cookie> cookie_list = new Hashtable<Cookie, Cookie>();
            Enumeration enumer = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext()).elements();
            while (enumer.hasMoreElements()) {
                Cookie cookie = (Cookie)enumer.nextElement();
                if (cookie.discard()) continue;
                cookie_list.put(cookie, cookie);
            }
            if (cookie_list.size() > 0) {
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cookie_jar));
                    oos.writeObject(cookie_list);
                    oos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static String getCookieJarName() {
        String file = null;
        try {
            file = System.getProperty("HTTPClient.cookies.jar");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null) {
            String os = System.getProperty("os.name");
            file = os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("16-bit Windows") || os.equalsIgnoreCase("Windows") ? System.getProperty("java.home") + File.separator + ".httpclient_cookies" : (os.equalsIgnoreCase("Windows NT") ? System.getProperty("user.home") + File.separator + ".httpclient_cookies" : (os.equalsIgnoreCase("OS/2") ? System.getProperty("user.home") + File.separator + ".httpclient_cookies" : (os.equalsIgnoreCase("Mac OS") || os.equalsIgnoreCase("MacOS") ? "System Folder" + File.separator + "Preferences" + File.separator + "HTTPClientCookies" : System.getProperty("user.home") + File.separator + ".httpclient_cookies")));
        }
        return file;
    }

    CookieModule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestHandler(Request req, Response[] resp) {
        req.setHeaders(Util.removeAllValues(req.getHeaders(), "Cookie"));
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, req.getConnection().getContext());
        if (cookie_list.size() == 0) {
            return 0;
        }
        Vector<String> names = new Vector<String>();
        Vector<Integer> lens = new Vector<Integer>();
        boolean cookie2 = false;
        Hashtable hashtable = cookie_list;
        synchronized (hashtable) {
            Enumeration list = cookie_list.elements();
            Vector<Cookie> remove_list = null;
            while (list.hasMoreElements()) {
                int idx;
                Cookie cookie = (Cookie)list.nextElement();
                if (cookie.hasExpired()) {
                    if (remove_list == null) {
                        remove_list = new Vector<Cookie>();
                    }
                    remove_list.addElement(cookie);
                    continue;
                }
                if (!cookie.sendWith(req) || cookie_handler != null && !cookie_handler.sendCookie(cookie, req)) continue;
                int len = cookie.getPath().length();
                for (idx = 0; idx < lens.size() && (Integer)lens.elementAt(idx) >= len; ++idx) {
                }
                names.insertElementAt(cookie.toExternalForm(), idx);
                lens.insertElementAt(new Integer(len), idx);
                if (!(cookie instanceof Cookie2)) continue;
                cookie2 = true;
            }
            if (remove_list != null) {
                for (int idx = 0; idx < remove_list.size(); ++idx) {
                    cookie_list.remove(remove_list.elementAt(idx));
                }
            }
        }
        if (!names.isEmpty()) {
            int idx;
            StringBuffer value = new StringBuffer();
            if (cookie2) {
                value.append("$Version=\"1\"; ");
            }
            value.append((String)names.elementAt(0));
            for (int idx2 = 1; idx2 < names.size(); ++idx2) {
                value.append("; ");
                value.append((String)names.elementAt(idx2));
            }
            NVPair[] hdrs = req.getHeaders();
            hdrs = Util.resizeArray(hdrs, hdrs.length + 1);
            hdrs[hdrs.length - 1] = new NVPair("Cookie", value.toString());
            if (!cookie2 && (idx = Util.getIndex(hdrs, "Cookie2")) == hdrs.length) {
                hdrs = Util.addValue(hdrs, "Cookie2", "$Version=\"1\"");
            }
            req.setHeaders(hdrs);
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getHeader("Set-Cookie");
        String set_cookie2 = resp.getHeader("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteHeader("Set-Cookie");
        resp.deleteHeader("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        String set_cookie = resp.getTrailer("Set-Cookie");
        String set_cookie2 = resp.getHeader("Set-Cookie2");
        if (set_cookie == null && set_cookie2 == null) {
            return;
        }
        resp.deleteTrailer("Set-Cookie");
        resp.deleteTrailer("Set-Cookie2");
        if (set_cookie != null) {
            this.handleCookie(set_cookie, false, req, resp);
        }
        if (set_cookie2 != null) {
            this.handleCookie(set_cookie2, true, req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCookie(String set_cookie, boolean cookie2, RoRequest req, Response resp) throws ProtocolException {
        Hashtable cookie_list;
        Cookie[] cookies = cookie2 ? Cookie2.parse(set_cookie, req) : Cookie.parse(set_cookie, req);
        Hashtable hashtable = cookie_list = Util.getList(cookie_cntxt_list, req.getConnection().getContext());
        synchronized (hashtable) {
            for (int idx = 0; idx < cookies.length; ++idx) {
                Cookie cookie = (Cookie)cookie_list.get(cookies[idx]);
                if (cookie != null && cookies[idx].hasExpired()) {
                    cookie_list.remove(cookie);
                    continue;
                }
                if (cookie_handler != null && !cookie_handler.acceptCookie(cookies[idx], req, resp)) continue;
                cookie_list.put(cookies[idx], cookies[idx]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discardAllCookies() {
        Hashtable hashtable = cookie_cntxt_list;
        synchronized (hashtable) {
            cookie_cntxt_list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discardAllCookies(Object context) {
        Hashtable cookie_list;
        Hashtable hashtable = cookie_list = Util.getList(cookie_cntxt_list, context);
        synchronized (hashtable) {
            cookie_list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies() {
        Hashtable hashtable = cookie_cntxt_list;
        synchronized (hashtable) {
            Cookie[] cookies = new Cookie[]{};
            int idx = 0;
            Enumeration cntxt_list = cookie_cntxt_list.elements();
            while (cntxt_list.hasMoreElements()) {
                Hashtable cntxt;
                Hashtable hashtable2 = cntxt = (Hashtable)cntxt_list.nextElement();
                synchronized (hashtable2) {
                    cookies = Util.resizeArray(cookies, idx + cntxt.size());
                    Enumeration cookie_list = cntxt.elements();
                    while (cookie_list.hasMoreElements()) {
                        cookies[idx++] = (Cookie)cookie_list.nextElement();
                    }
                }
            }
            return cookies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies(Object context) {
        Hashtable cookie_list;
        Hashtable hashtable = cookie_list = Util.getList(cookie_cntxt_list, context);
        synchronized (hashtable) {
            Cookie[] cookies = new Cookie[cookie_list.size()];
            int idx = 0;
            Enumeration enumer = cookie_list.elements();
            while (enumer.hasMoreElements()) {
                cookies[idx++] = (Cookie)enumer.nextElement();
            }
            return cookies;
        }
    }

    public static void addCookie(Cookie cookie) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.put(cookie, cookie);
    }

    public static void addCookie(Cookie cookie, Object context) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, context);
        cookie_list.put(cookie, cookie);
    }

    public static void removeCookie(Cookie cookie) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        cookie_list.remove(cookie);
    }

    public static void removeCookie(Cookie cookie, Object context) {
        Hashtable cookie_list = Util.getList(cookie_cntxt_list, context);
        cookie_list.remove(cookie);
    }

    public static synchronized CookiePolicyHandler setCookiePolicyHandler(CookiePolicyHandler handler) {
        CookiePolicyHandler old = cookie_handler;
        cookie_handler = handler;
        return old;
    }

    static {
        boolean persist;
        cookie_cntxt_list = new Hashtable();
        cookie_jar = null;
        cookie_handler = new DefaultCookiePolicyHandler();
        try {
            String dont = System.getProperty("HTTPClient.cookies.dontSave");
            persist = Boolean.valueOf(dont) == false;
        }
        catch (Exception e) {
            persist = false;
        }
        if (persist) {
            cookie_jar = new File(CookieModule.getCookieJarName());
            if (cookie_jar.isFile() && cookie_jar.canRead()) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cookie_jar));
                    cookie_cntxt_list.put(HTTPConnection.getDefaultContext(), (Hashtable)ois.readObject());
                    ois.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                System.runFinalizersOnExit((boolean)true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

