/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.IdempotentSequence;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RetryException;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.IOException;

class RetryModule
implements HTTPClientModule,
GlobalConstants {
    RetryModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responsePhase1Handler(Response resp, RoRequest roreq) throws IOException, ModuleException {
        try {
            resp.getStatusCode();
        }
        catch (RetryException re) {
            boolean got_lock = false;
            try {
                RetryException retryException = re.first;
                synchronized (retryException) {
                    got_lock = true;
                    IdempotentSequence seq = new IdempotentSequence();
                    RetryException e = re.first;
                    while (e != null) {
                        seq.add(e.request);
                        e = e.next;
                    }
                    e = re.first;
                    while (e != null) {
                        Request req = e.request;
                        HTTPConnection con = req.getConnection();
                        if (Thread.currentThread().isInterrupted() || !seq.isIdempotent(req) || con.ServProtVersKnown && con.ServerProtocolVersion >= 65537 && req.num_retries > 0 || (!con.ServProtVersKnown || con.ServerProtocolVersion <= 65536) && req.num_retries > 4 || e.response.got_headers) {
                            e.first = null;
                        } else if (req.getStream() != null) {
                            e.first = null;
                            req.getStream().reset();
                            e.response.setRetryRequest(true);
                        } else {
                            if (req.getData() != null && e.conn_reset) {
                                if (con.ServProtVersKnown && con.ServerProtocolVersion >= 65537) {
                                    req.setHeaders(Util.addToken(req.getHeaders(), "Expect", "100-continue"));
                                } else {
                                    req.delay_entity = 5000L << req.num_retries;
                                }
                            }
                            if (e.next != null && e.next.request.getData() != null && (!con.ServProtVersKnown || con.ServerProtocolVersion < 65537) && e.conn_reset) {
                                req.setHeaders(Util.addToken(req.getHeaders(), "Connection", "close"));
                            }
                            if (con.ServProtVersKnown && con.ServerProtocolVersion >= 65537 && e.conn_reset) {
                                req.dont_pipeline = true;
                            }
                            if (e.conn_reset) {
                                ++req.num_retries;
                            }
                            e.response.http_resp.set(req, con.sendRequest(req, e.response.timeout));
                            e.exception = null;
                            e.first = null;
                        }
                        e = e.next;
                    }
                }
            }
            catch (NullPointerException npe) {
                if (got_lock) {
                    throw npe;
                }
            }
            catch (ParseException pe) {
                throw new IOException(pe.getMessage());
            }
            if (re.exception != null) {
                throw re.exception;
            }
            re.restart = true;
            throw re;
        }
    }

    public int responsePhase2Handler(Response resp, Request req) {
        req.delay_entity = 0L;
        req.dont_pipeline = false;
        req.num_retries = 0;
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

