/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

public abstract class DocumentBuilderFactory {
    private boolean validating = false;
    private boolean namespaceAware = false;

    protected DocumentBuilderFactory() {
    }

    public static DocumentBuilderFactory newInstance() {
        DocumentBuilderFactory documentBuilderFactory;
        String string = null;
        try {
            string = System.getProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.xml.parser.DocumentBuilderFactoryImpl");
        }
        catch (SecurityException securityException) {
            string = "com.sun.xml.parser.DocumentBuilderFactoryImpl";
        }
        try {
            Class<?> clazz = Class.forName(string);
            documentBuilderFactory = (DocumentBuilderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryConfigurationError(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FactoryConfigurationError(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new FactoryConfigurationError(instantiationException);
        }
        return documentBuilderFactory;
    }

    public abstract DocumentBuilder newDocumentBuilder() throws ParserConfigurationException;

    public void setNamespaceAware(boolean bl) {
        this.namespaceAware = bl;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }
}

